// ===========================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
// ===========================================================================

#ifndef __StdArrayH__
#define __StdArrayH__

#include <fstream.h>
#include "StdAssert.h"

// ===========================================================================
// Template class StdArray<ZZ>  implements an array of objects of class ZZ with
// the familiar C style array mechanisms. Array elements begin at index 0 and
// are accessed using the [] operator. 
// Class ZZ must have a default constructor and a valid assignment operator.
// ===========================================================================

template<class ZZ>
class StdArray
{
  public:
    // Constructors
    StdArray(int size = 0);                              
    StdArray(const StdArray<ZZ>&);
   ~StdArray(void);

    // Assignment 
    const StdArray<ZZ>& operator = (const StdArray<ZZ>&);

    // Access to data
    inline const ZZ& operator [] (int i) const;
    inline       ZZ& operator [] (int i);
    inline int Size(void) const;

    // Changing the array size
    void Resize(int newsize);
    void ResizeSave(int newsize);

    // Printing the array
    void Print(ostream& os) const;

  protected:
    int fSize;  // the array size
    ZZ* fX;     // pointer to the array
};


// Non member function declarations ..........................................

// Functions to print the  array 
template<class ZZ>  ostream&  operator << ( ostream&, const StdArray<ZZ>&);
template<class ZZ>  ofstream& operator << (ofstream&, const StdArray<ZZ>&);

// Function for saving and retrieving the state of the array
template<class ZZ>  void LoadState(istream&, StdArray<ZZ>&);
template<class ZZ>  void SaveState(ostream&, StdArray<ZZ>&); 
template<class ZZ>  void LoadState(ifstream&, StdArray<ZZ>&);
template<class ZZ>  void SaveState(ofstream&, StdArray<ZZ>&); 


// Inlines function definitions ..............................................

template<class ZZ> inline const ZZ& StdArray<ZZ>::operator[] (int i) const
{ assert((i>=0)&&(i<fSize)); return( fX[i] ); }

template<class ZZ> inline ZZ& StdArray<ZZ>::operator[] (int i)    
{ assert((i>=0)&&(i<fSize)); return( fX[i] ); }

template<class ZZ> inline int StdArray<ZZ>::Size(void) const            
{ return( fSize ); }

// ...........................................................................

#endif



