<!DOCTYPE HTML SYSTEM "html.dtd">
<HTML><HEAD><TITLE>  examples: StdVector </TITLE></HEAD>
<BODY> 

<H3> Examples: </H3>
 
<PRE>#include "StdVector.h"</PRE> 

<STRONG> Constructors </STRONG><BR>
<CODE> StdVector  w;                  </CODE><EM> Creates a 0(default) dimensional vector. </EM> <BR>
<CODE> StdVector  x(5);               </CODE><EM> Creates a 5 dimensional vector x.        </EM> <BR>
<CODE> StdVector  y(1.0, 2.0);        </CODE><EM> Creates a 2-d vector y = [1.0, 2.0]      </EM> <BR>
<CODE> StdVector  z(1.0, 2.0, 3.0);   </CODE><EM> Creates a 3-d vector z = [1.0, 2.0, 3.0] </EM> <BR>
<BR>

<CODE> StdVector  a(x);  </CODE><EM> Creates a copy of the vector x. </EM> <BR>
<CODE> StdVector  b = x; </CODE><EM> Creates a copy of the vector x. </EM> <BR>
<CODE> y = x;          </CODE><EM> Assigns vector x to vector y.   </EM> <BR>
<BR>

<STRONG> Access to data </STRONG><BR>
<CODE> double l = w[i];              </CODE><EM> Reads ith element of vector w. </EM> <BR>
<CODE> w[i] = 66.0;                  </CODE><EM> Writes to ith element of vector w.   </EM> <BR>
<CODE> int n = w.Size();             </CODE><EM> Gets the dimension of vector w. </EM> <BR>
<STRONG> - for 2-D and 3-D vectors </STRONG><BR>
<CODE> double x_component = w.X();   </CODE><EM> Alternative way of reading  w[0]  </EM><BR>
<CODE> double y_component = w.Y();   </CODE><EM> Alternative way of reading  w[1]  </EM><BR>
<CODE> double z_component = w.Z();   </CODE><EM> Alternative way of reading  w[2]  </EM><BR><BR>





<STRONG> Vector math operations </STRONG><BR>
<CODE> z = x + y; </CODE> <EM> Vector addition. </EM> <BR>
<CODE> z = x - y; </CODE> <EM> Vector subtraction. </EM> <BR>
<CODE> z = 5.0*x;   </CODE> <EM> Scalar multiplication </EM> <BR>
<CODE> z = x*5.0;   </CODE> <EM> Scalar multiplication </EM> <BR>
<CODE> z = x/5.0;   </CODE> <EM> Scalar division </EM> <BR>
<CODE> double d = x*y;  </CODE> <EM> Dot product(scalar product) </EM> <BR><BR>

<CODE> x += y; </CODE>   <EM> Vector addition. x = x + y        </EM> <BR>
<CODE> x -= y; </CODE>   <EM> Vector subtraction. x = x - y     </EM> <BR>
<CODE> x *= 5.0; </CODE> <EM> Scalar multiplication. x =  5x    </EM> <BR>
<CODE> x /= 2.0; </CODE> <EM> Scalar division. x = x/2          </EM> <BR>
<BR>

<STRONG> Changing the vector size </STRONG><BR>
<CODE> x.Resize(20);          </CODE><EM> Replaces x with a new vector of specified size. </EM> <BR>
<CODE> x.ResizeSave(20);      </CODE><EM> Replaces x with a new vector of specified size and copies contents of previous vector into new vector. </EM> <BR><BR>

<STRONG> Printing the vector </STRONG><BR> 
<CODE> x.Print(cout);      </CODE><EM> Print each element of vector x on ostream. </EM> <BR>
<CODE> cout << x;          </CODE><EM> Print each element of vector x on ostream. </EM> <BR><BR>

<STRONG> Saving and retrieving the object </STRONG><BR>
<CODE> SaveState(os, x);  </CODE><EM> Save state of the vector on ostream os.</EM> <BR> 
<CODE> LoadState(is, x);  </CODE><EM> Retrieve state of the vector from istream is.</EM> <BR><BR>

<HR>

<EM>
 Copyright (c) 1995 Leslie Picardo 
 <A HREF="mailto:picardo@alpha.ces.cwru.edu"> (picardo@alpha.ces.cwru.edu)</A>  <BR>
 All rights reserved              
</EM>
<HR>



</BODY>
</HTML>


