<HTML>
<HEAD><TITLE> class StdVector    </TITLE></HEAD>

<BODY> 

<H3> Class StdVector  </H3>
<PRE>
<a href="StdArray.d"> StdArray&lt;double> </a>
   |
   +----StdVector
</PRE>
<HR>


<DL> 
  <DT> <b> Description: </b>
  <DD> A class that produces a vector and implements vector math operations. <BR><BR>
  <DT> <b>Source code: </b>
  <DD> <A HREF="../Include/StdVector.h"> StdVector.h </A> <BR>
       <A HREF="../Include/StdVector.c"> StdVector.c </A> <BR><BR>
  <DT> <A HREF ="StdVector.e">  <b>Examples: </b></A>
</DL>

<HR>
<P> <img src="images/constructors.gif"> </P>
<DL>
  <DT> <img src="images/yellow-ball-small.gif">
       <b><CODE> StdVector(int size = 0);  </CODE></b> 
  <DD> Create a vector of the specified size.
  <DT> <img src="images/yellow-ball-small.gif">
       <b><CODE> StdVector(double x, double y);  </CODE></b> 
  <DD> Create a two dimensional vector [x, y].
  <DT> <img src="images/yellow-ball-small.gif">
       <b><CODE> StdVector(double x, double y, double z);  </CODE></b> 
  <DD> Create a three dimensional vector [x, y, z].
</DL>

<P> <img src="images/methods.gif"> </P>
 <DL> 
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> StdVector& operator+=(const StdVector& v);</CODE></b> Vector addition. 
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> StdVector& operator-=(const StdVector& v);</CODE></b> Vector subtraction.
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> StdVector& operator*=(double x);</CODE></b> Multiplication with a scalar.
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> StdVector& operator/=(double x); </CODE></b> Division by a scalar. <BR><BR>
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> void Zeros();</CODE></b>  Set each element of the vector to 0.0
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> void Ones();</CODE></b> Set each element of the vector to 1.0<BR><BR>
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> inline double X(void) const; </CODE></b> 
    Read the first element of the vector.
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> inline double Y(void) const; </CODE></b> 
    Read the second element of the vector.
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> inline double Z(void) const; </CODE></b> 
    Read the third element of the vector <BR><BR>
</DL>

<P> <img src="images/functions.gif"> </P>
<DL> 
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE>StdVector operator+(const StdVector& v, const StdVector& w);    </CODE></b>
 <DD> Vector addition. Returns <b><CODE>v + w</CODE></b>  
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE>StdVector operator-(const StdVector& v, const StdVector& w);    </CODE></b>
 <DD> Vector subtraction. Returns <b><CODE>v - w</CODE></b> 
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE>StdVector operator*(const StdVector& v, double k);    </CODE></b>
 <DD> Multiplication by a scalar. Returns <b><CODE>v.k</CODE></b> 
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE>StdVector operator*(double k, const StdVector& v);    </CODE></b>
 <DD> Multiplication by a scalar. Returns <b><CODE>k.v</CODE></b> 
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE>StdVector operator/(const StdVector&, double);    </CODE></b>
 <DD> Division by a scalar. Returns <b><CODE>v/k</CODE></b> 
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE>double    operator*(const StdVector& v, const StdVector& w);    </CODE></b>
 <DD> Scalar product of two vectors. Returns <b><CODE>v*w</CODE></b> <BR><BR>
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE>ostream&  operator << ( ostream&, const StdVector& v);    </CODE></b>
 <DD> Print the vector <b><CODE>v</CODE></b> on the ostream <b><CODE>os</CODE></b> <BR><BR>

 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE> void SaveState(ostream& os, StdVector& v);   </CODE></b>
 <DD> Save the state of the vector <b><CODE>v</CODE></b> on the ostream <b><CODE>os</CODE></b>  
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE> void LoadState(istream& is, StdVector& v);   </CODE></b>
 <DD> Load  the state of the vector <b><CODE>v</CODE></b> from the istream <b><CODE>is</CODE></b><BR><BR>
</DL>



<HR>

<EM>
 Copyright (c) 1995 Leslie Picardo 
 <A HREF="mailto:picardo@alpha.ces.cwru.edu"> (picardo@alpha.ces.cwru.edu)</A>  <BR>
 All rights reserved              
</EM>
<HR>



</BODY>
</HTML>


