<!DOCTYPE HTML SYSTEM "html.dtd">
<HTML><HEAD><TITLE> examples: StdMatrix&lt;T> </TITLE></HEAD>
<BODY> 

<H3> Examples: </H3>
 
 
<PRE>#include "StdMatrix.h"</PRE> 


<STRONG> Constructors </STRONG><BR>
<CODE> StdMatrix&lt;int>  x(3,5); </CODE><EM> Creates a 3x5 matrix of ints. </EM> <BR>
<CODE> StdMatrix&lt;int>  y;     </CODE><EM> Creates a 0x0(default size) matrix of ints. </EM> <BR>
<CODE> StdMatrix&lt;int>  a(x);  </CODE><EM> Creates a copy of the matrix x. </EM> <BR>
<CODE> StdMatrix&lt;int>  b = x; </CODE><EM> Creates a copy of the matrix x. </EM> <BR>
<CODE> y = x;                 </CODE><EM> Assigns matrix x to matrix y.    </EM> <BR><BR>


<STRONG> Access to data </STRONG><BR>
<CODE> int n = x[i][j];    </CODE><EM> Reads the element in row i and column j of matrix x. </EM> <BR>
<CODE> x[i][j] = 66;       </CODE><EM> Writes to the element in row i and column j matrix of x.   </EM> <BR>
<CODE> int r  = x.Rows();  </CODE><EM> Gets the number of rows in matrix x. </EM> <BR>
<CODE> int c  = x.Cols();  </CODE><EM> Gets the number of columns in matrix x. </EM> <BR>
<CODE> int *p = x[i]       </CODE><EM> Returns a pointer to the ith row(array) in matrix x </EM> <BR>
<BR>


<STRONG> Changing the matrix size </STRONG><BR>
<CODE> x.Resize(5,8);     </CODE><EM> Replaces x with a new matrix with specified rows and columns. </EM> <BR>
<CODE> x.ResizeSave(5,8); </CODE><EM> Replaces x with a new matrix of specified rows and columns and copies contents of previous matrix into new matrix. </EM> <BR><BR>

<STRONG> Printing the matrix </STRONG><BR> 
<CODE> x.Print(cout);      </CODE><EM> Print each element of matrix x on ostream. </EM> <BR>
<CODE> cout << x;          </CODE><EM> Print each element of matrix x on ostream. </EM> <BR><BR>



<STRONG> Saving and retrieving the object </STRONG><BR>
<CODE> SaveState(os, x); </CODE><EM> Save state of the matrix on ostream os.</EM> <BR>
<CODE> LoadState(is, x); </CODE><EM> Retrieve state of the matrix from istream is.</EM> <BR><BR>


<HR>

<EM>
 Copyright (c) 1995 Leslie Picardo 
 <A HREF="mailto:picardo@alpha.ces.cwru.edu"> (picardo@alpha.ces.cwru.edu)</A>  <BR>
 All rights reserved              
</EM>
<HR>



</BODY>
</HTML>


