<HTML><HEAD><TITLE> examples: StdBitString </TITLE></HEAD>
<BODY> 

<H3> Examples: </H3>
 
<PRE>#include "StdBitString.h"</PRE> 


<STRONG> Constructors </STRONG><BR>
<CODE> StdBitString  x(10); </CODE><EM> Creates a bitstring of 10 bits. </EM><BR>
<CODE> StdBitString  y;     </CODE><EM> Creates a 1 bit(default size) bitstring. </EM><BR>
<CODE> StdBitString  a(x);  </CODE><EM> Creates a copy of the bitstring x. </EM><BR>
<CODE> StdBitString  a(x,1,3); </CODE><EM> Creates a copy of bits 1...3 in the bitstring x. </EM><BR>
<CODE> StdBitString  b = x; </CODE><EM> Creates a copy of the bitstring x. </EM><BR>
<CODE> y = x;             </CODE><EM> Assigns bitstring x to bitstring y.</EM><BR>
<BR>

<STRONG> Extracting a substring </STRONG><BR>
<CODE> y = x.SubString(1,3);</CODE><EM> Returns a copy of bits 1..3 in the bitstring x. </EM><BR>
<BR>


<STRONG> Access to data </STRONG><BR>
<CODE> int m  = x.NumberOfBits(); </CODE><EM> Returns the number of bits in bitstring x. </EM><BR>
<CODE> int n  = x.Size();         </CODE><EM> Returns the number of bits in bitstring x. </EM><BR>
<CODE> int bit = x[3];            </CODE><EM> Reads the 3rd bit of bitstring x. Note that the int returned
is a 0 if the bit is 0 and ~0 if the bit is 1.    </EM><BR>
<BR>

<STRONG> Operations on individual bits  </STRONG><BR>
<CODE> x.Set(5); </CODE>   <EM> Sets bit 5 of bitstring x to 1          </EM><BR>
<CODE> x.Clear(5); </CODE> <EM> Sets bit 5 of bitstring x to 0          </EM><BR>
<CODE> x.Invert(5); </CODE><EM> Inverts(toggles) bit 5 of bitstring x   </EM><BR>
<BR>

<STRONG> Operations on entire bitstring </STRONG><BR>
<CODE> x.Set(); </CODE>   <EM> Sets all bits of bitstring x to 1          </EM><BR>
<CODE> x.Clear(); </CODE> <EM> Sets all bits of bitstring x to 0          </EM><BR>
<CODE> x.Invert(); </CODE><EM> Inverts(toggles) all bits of bitstring x   </EM><BR>
<CODE> x = a & b;  </CODE><EM> Bitwise AND of bitstring a with bitstring b  </EM> <BR>
<CODE> x = a | b;  </CODE><EM> Bitwise OR of bitstring a with bitstring b  </EM> <BR>
<CODE> x = a ^ b;  </CODE><EM> Bitwise XOR of bitstring a with bitstring b  </EM> <BR>
<CODE> x &= y;     </CODE><EM> Same as x = x & y </EM> <BR>
<CODE> x |= y;     </CODE><EM> Same as x = x</EM> | <EM> y </EM> <BR>
<CODE> x ^= y;     </CODE><EM> Same as x = x ^ y </EM> <BR>
<BR>

<STRONG> Changing the bitstring size </STRONG><BR>
<CODE> x.Resize(8);     </CODE><EM> Replaces x with a new bitstring of specified size.</EM><BR>
<CODE> x.ResizeSave(8); </CODE><EM> Replaces x with a new bitstring of specified size. Copies 
                                    contents of previous bitstring into new bitstring.</EM> <BR>
<BR>
<STRONG> Binary, Grey and Decimal conversion </STRONG><BR>
<CODE> x.BinaryToGrey();  </CODE><EM> Interpret the bitstring x as a binary code and convert x to grey code  </EM><BR>
<CODE> x.GreyToBinary();  </CODE><EM> Interpret the bitstring x as a grey code and convert x  to binary code </EM><BR>
<CODE> ConvertBinaryToGrey(x, y); </CODE><EM> Replace y with grey code equivalent of binary coded x. </EM><BR>
<CODE> ConvertGreyToBinary(x, y); </CODE><EM> Replace y with binary code equivalent of grey coded x. </EM><BR>

<CODE> double d = ConvertBinaryToDecimal(x); </CODE> <BR><EM> Returns the decimal equivalent of the binary code in 
       bitstring x.</EM><BR>
<CODE> double d = ConvertBinaryToDecimal(x, 2, 5);</CODE> <BR><EM> Returns the decimal equivalent of the binary code 
from bits 2 till 5 in the bitstring x. </EM><BR>
<BR>

<STRONG> Printing the bitstring </STRONG><BR> 
<CODE> x.Print(cout);      </CODE><EM> Print the bitstring on the ostream. </EM> <BR>
<CODE> cout << x;          </CODE><EM> Print the bitstring on the ostream. </EM> <BR><BR>

<STRONG> Saving and retrieving the object </STRONG><BR>
<CODE> SaveState(os, x); </CODE><EM> Save state of the bitstring on ostream os.</EM> <BR>
<CODE> LoadState(is, x); </CODE><EM> Retrieve state of the bitstring from istream is.</EM> <BR><BR>

<HR>

<EM>
 Copyright (c) 1995 Leslie Picardo 
 <A HREF="mailto:picardo@alpha.ces.cwru.edu"> (picardo@alpha.ces.cwru.edu)</A>  <BR>
 All rights reserved              
</EM>
<HR>



</BODY>
</HTML>


