#include "EvPendulumPerf.h"
#include "VwPendulum.h"
#include "XppXYPlot.h"

main()
{
  

  double simulationTime; cout << "Simulation Time ? "; cin >> simulationTime;
  double stepSize = 0.01;

  double initialTheta; cout << "Initial Theta ? "; cin >> initialTheta;

  EvPendulumPerformance  p("network.best");
  VwPendulum pv;  pv.View(p.fPendulum);  pv.UpdateRate(10);

  //XppWindow plot(600,300,-1,-1,"Plots");
  XppWindow plot(600,100,-1,-1,"Plots");
  XppXYPlot fplot(plot, 600,100, 0, 0);
  //XppXYPlot o4plot(plot,600,100, 0, 100);
  //XppXYPlot o9plot(plot,600,100, 0, 200);

  fplot.SetDrawingCoordinates(0.0, simulationTime, -40, 40.0);
  fplot.SetAutoRedrawOnExpose();
  //o4plot.SetDrawingCoordinates(0.0, simulationTime, 0.0, 1.0);
  //o4plot.SetAutoRedrawOnExpose();
  //o9plot.SetDrawingCoordinates(0.0, simulationTime, 0.0, 1.0);
  //o9plot.SetAutoRedrawOnExpose();


  //p.fNetwork.Reset();	
  //for(double t = 0.0; t < 1.0; t += stepSize)
  //  p.fNetwork.Step(stepSize);

  p.fPendulum.Reset(initialTheta, 0.0, 0.0, 0.0);
  for(double time = 0.0; time < simulationTime; time += stepSize)
    {
      p.Step( stepSize );
      fplot.Plot( time, p.fPendulum.Force() ); fplot.Flush();
      //o4plot.Plot( time, p.fNetwork.Output(2) ); o4plot.Flush();
      //o9plot.Plot( time, p.fNetwork.Output(5) ); o9plot.Flush();
      pv.Update(); pv.Flush();
    }
  gXManager.Run();
}


