#include "EvPendulumPerf.h"
#include "VwPendulum.h"
#include "XppXYPlot.h"

main()
{
  

  double simulationTime; cout << "Simulation Time ? "; cin >> simulationTime;
  double stepSize = 0.01;

  double initialTheta; cout << "Initial Theta ? "; cin >> initialTheta;

  EvPendulumPerformance  p("network.best");
  VwPendulum pv;  pv.View(p.fPendulum);  pv.UpdateRate(10);

  XppWindow plot(600,300,-1,-1,"Plots");
  XppXYPlot fplot(plot, 600,100, 0, 0);

  XppXYPlot o0plot(plot,600,100, 0, 100);  
  XppXYPlot o1plot(plot,600,100, 0, 120);  
  XppXYPlot o2plot(plot,600,100, 0, 140);  
  XppXYPlot o3plot(plot,600,100, 0, 160);  
  XppXYPlot o4plot(plot,600,100, 0, 180);
  XppXYPlot o5plot(plot,600,100, 0, 200);
  XppXYPlot o6plot(plot,600,100, 0, 220);
  XppXYPlot o7plot(plot,600,100, 0, 240);
  XppXYPlot o8plot(plot,600,100, 0, 260);
  XppXYPlot o9plot(plot,600,100, 0, 280);


  fplot.SetDrawingCoordinates(0.0, simulationTime, -40, 40.0);
  o0plot.SetDrawingCoordinates(0.0, simulationTime, 0.0, 1.0);
  o1plot.SetDrawingCoordinates(0.0, simulationTime, 0.0, 1.0);
  o2plot.SetDrawingCoordinates(0.0, simulationTime, 0.0, 1.0);
  o3plot.SetDrawingCoordinates(0.0, simulationTime, 0.0, 1.0);
  o4plot.SetDrawingCoordinates(0.0, simulationTime, 0.0, 1.0);
  o5plot.SetDrawingCoordinates(0.0, simulationTime, 0.0, 1.0);
  o6plot.SetDrawingCoordinates(0.0, simulationTime, 0.0, 1.0);
  o7plot.SetDrawingCoordinates(0.0, simulationTime, 0.0, 1.0);
  o8plot.SetDrawingCoordinates(0.0, simulationTime, 0.0, 1.0);
  o9plot.SetDrawingCoordinates(0.0, simulationTime, 0.0, 1.0);

  p.fNetwork.Reset();	
  for(double t = 0.0; t < 1.0; t += stepSize)
    {
      p.fNetwork.Step(stepSize);
      o0plot.Plot( t, p.fNetwork.Output(0) ); 
      o1plot.Plot( t, p.fNetwork.Output(1) ); 
      o2plot.Plot( t, p.fNetwork.Output(2) ); 
      o3plot.Plot( t, p.fNetwork.Output(3) ); 
      o4plot.Plot( t, p.fNetwork.Output(4) ); 
      o5plot.Plot( t, p.fNetwork.Output(5) ); 
      o6plot.Plot( t, p.fNetwork.Output(6) ); 
      o7plot.Plot( t, p.fNetwork.Output(7) ); 
      o8plot.Plot( t, p.fNetwork.Output(8) ); 
      o9plot.Plot( t, p.fNetwork.Output(9) ); 
      plot.Flush();
    }
  plot.Pause();

  p.fPendulum.Reset(initialTheta, 0.0, 0.0, 0.0);
  for(double time = 0.0; time < simulationTime; time += stepSize)
    {
      p.Step( stepSize );
      fplot.Plot( time, p.fPendulum.Force() ); 
      o0plot.Plot( time, p.fNetwork.Output(0) ); 
      o1plot.Plot( time, p.fNetwork.Output(1) ); 
      o2plot.Plot( time, p.fNetwork.Output(2) ); 
      o3plot.Plot( time, p.fNetwork.Output(3) ); 
      o4plot.Plot( time, p.fNetwork.Output(4) ); 
      o5plot.Plot( time, p.fNetwork.Output(5) ); 
      o6plot.Plot( time, p.fNetwork.Output(6) ); 
      o7plot.Plot( time, p.fNetwork.Output(7) ); 
      o8plot.Plot( time, p.fNetwork.Output(8) ); 
      o9plot.Plot( time, p.fNetwork.Output(9) ); 
      pv.Update(); pv.Flush();
    }
  gXManager.Run();
}








