// ==========================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
// ==========================================================================
#ifndef __EvPendulumPerformanceH__
#define __EvPendulumPerformanceH__

#include "EvPerformance.h"
#include "SysPendulum.h"
#include "SysNNetwork.h"

class  EvPendulumPerformance: public EvPerformance
{
  public:
    EvPendulumPerformance(void);
    EvPendulumPerformance(char *filename);

    virtual double Evaluate(const StdArray<double>&);
    double Simulate(double simulationTime);

    void Step(double stepSize);
    
    SysNNetwork  fNetwork;
    SysPendulum  fPendulum;
    double     fBestPerformance;

    void CopyParametersToNetwork(const StdArray<double>&);
};


#endif


















