// ==========================================================================
// Copyright (c) 1995 Leslie Picardo.  All rights reserved
// ==========================================================================

#ifndef __EvPerformanceH__
#define __EvPerformanceH__

#include "StdArray.h"
#include "StdBitString.h"

// ==========================================================================
// The  EvPerformance class defines  the abstract interface of any performance
// function class. 
// The Size() query returns the dimension of the search space.
// The Evaluate() function returns the performance function value for an
// array of reals or a bitstring.
// ==========================================================================



class EvPerformance 
{
 public:
  virtual ~EvPerformance(void) {};

 // Dimension of the search space
  virtual int Size(void) const { return (fSearchDimension); }
  
 // Evaluate the performance
  virtual double Evaluate(const StdArray<double>&) { return(0); } 
  virtual double Evaluate(const StdBitString&)  { return(0); } 

 protected:
  int fSearchDimension; // The dimension of the search space
};

extern EvPerformance  *gPerformanceFunction;   
#endif


