//============================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//============================================================================

#include "StdTypes.h"  
#include "EvIndividual.h"
#include "EvPerformance.h"   

//============================================================================
template<class ZZ>  
EvIndividual<ZZ>::EvIndividual(void) 
  : fGenome( gPerformanceFunction->Size()),  
    fPerformance(0),
    fFitness(0)
{ }


//===========================================================================
template<class ZZ>  void EvIndividual<ZZ>::Evaluate(void)
{
  // Pass the genome to the performance function for evaluation
  fPerformance = gPerformanceFunction->Evaluate( fGenome );    
}  




//===========================================================================
template<class ZZ>  void EvIndividual<ZZ>::Randomize(void)
{
  // Randomize the genome
  fGenome.Randomize();
}  



//============================================================================
template<class ZZ> 
void EvIndividual<ZZ>::Print(ostream& os) const
{
  os << fPerformance << " " << fFitness << " " << fGenome;
}


//============================================================================
template<class ZZ> 
ostream& operator << (ostream& os, const EvIndividual<ZZ>& s)
{
  s.Print(os); 
  return(os);
}


//============================================================================
template<class ZZ>
void LoadState(ifstream& ifs, EvIndividual<ZZ>& a)
{
  istream& is = ifs;  // Convert to an istream
  LoadState(is, a);   // Call istream equivalent template function
}


//============================================================================
template<class ZZ>
void SaveState(ofstream& ofs, EvIndividual<ZZ>& a)
{
  ostream& os = ofs; // Convert to an ostream
  SaveState(os, a);  // Call ostream equivalent template function
}


//============================================================================
template<class ZZ>
void LoadState(istream& is, EvIndividual<ZZ>& a)
{
  LoadState( is, a.fPerformance ); 
  LoadState( is, a.fFitness ); 
  LoadState( is, a.fGenome );     // Load the genome
}


//============================================================================
template<class ZZ>
void SaveState(ostream& os, EvIndividual<ZZ>& a)
{
  SaveState( os, a.fPerformance );
  SaveState( os, a.fFitness );
  SaveState( os, a.fGenome );     // Save the state of the genome
}















