//============================================================================
// Copyright (c) 1995 Leslie  Picardo. All rights reserved
//============================================================================
#ifndef  __EvRealGenomeH__
#define  __EvRealGenomeH__

#include "StdVector.h"

//============================================================================
// A EvRealGenome is a genome in which each gene is a real number.
//============================================================================

class EvRealGenome : public StdVector
{
  public:
  // Constructors
  EvRealGenome(int size = 0);    

  // StdVector functions are inherited 

  // Randomizing the genes of the genome
  void Randomize(double min = -1.0, double max = 1.0); 

  // Mutation
  void Mutate(double mutationVariance, double mutationMean = 0.0);         
};

// Crossover operators .......................................................
void 
OnePointCrossover(const EvRealGenome& parent1, const EvRealGenome& parent2,
                        EvRealGenome& child1,        EvRealGenome& child2 );
void 
TwoPointCrossover(const EvRealGenome& parent1, const EvRealGenome& parent2, 
		        EvRealGenome& child1,        EvRealGenome& child2 );
void
UniformCrossover(const EvRealGenome& parent1, const EvRealGenome& parent2, 
                       EvRealGenome& child1,        EvRealGenome& child2, 
                 double probability );

// Non-member functions ......................................................

// Printing the genome
ostream& operator << (ostream& os, const EvRealGenome& g);

// Saving and retrieving the state of the genome
void LoadState(istream&, EvRealGenome& );
void SaveState(ostream&, EvRealGenome& );





#endif

