<!DOCTYPE HTML SYSTEM "html.dtd">
<HTML><HEAD><TITLE> class TBitGenome </TITLE></HEAD>
<BODY> 

<CENTER> <H2>TBitGenome  </H2>  </CENTER>
 
<H3>   Description: </H3>
 
<P> The TBitGenome class lets you  create a genome  that is an 
     array of bits.<BR>
    The bits are numbered from left to right starting with  bit 0.
</P>
<H3>  The source code: </H3>
<P>
<A HREF="bitgenome.h" > bitgenome.h  </A> <BR>
<A HREF="bitgenome.cc"> bitgenome.cc </A> <BR>
</P>

<HR>
<H3> Usage: </H3>
 
<PRE>#include "bitgenome.h"</PRE> 


<STRONG> Constructors </STRONG><BR>
<CODE> TBitGenome  x(10); </CODE><EM> Creates a bitgenome of 10 bits. </EM><BR>
<CODE> TBitGenome  y;     </CODE><EM> Creates a 1 bit(default size) bitgenome. </EM><BR>
<CODE> TBitGenome  a(x);  </CODE><EM> Creates a copy of the bitgenome x. </EM><BR>
<CODE> TBitGenome  a(x,1,3); </CODE><EM> Creates a copy of bits 1...3 in the bitgenome x. </EM><BR>
<CODE> TBitGenome  b = x; </CODE><EM> Creates a copy of the bitgenome x. </EM><BR>
<CODE> y = x;             </CODE><EM> Assigns bitgenome x to bitgenome y.</EM><BR>
<BR>

<STRONG> Extracting a substring </STRONG><BR>
<CODE> y = x.SubString(1,3);</CODE><EM> Returns a copy of bits 1..3 in the bitgenome x. </EM><BR>
<BR>


<STRONG> Access to data </STRONG><BR>
<CODE> int m  = x.NumberOfBits(); </CODE><EM> Returns the number of bits in bitgenome x. </EM><BR>
<CODE> int n  = x.Size();         </CODE><EM> Returns the number of bits in bitgenome x. </EM><BR>
<CODE> int bit = x[3];             </CODE><EM> Reads the 3rd bit of bitgenome x.          </EM><BR>
<BR>

<STRONG> Operations on individual bits  </STRONG><BR>
<CODE> x.Set(5); </CODE>   <EM> Sets bit 5 of bitgenome x to 1          </EM><BR>
<CODE> x.Clear(5); </CODE> <EM> Sets bit 5 of bitgenome x to 0          </EM><BR>
<CODE> x.Invert(5); </CODE><EM> Inverts(toggles) bit 5 of bitgenome x   </EM><BR>
<BR>

<STRONG> Operations on entire bitgenome </STRONG><BR>
<CODE> x.Set(); </CODE>   <EM> Sets all bits of bitgenome x to 1          </EM><BR>
<CODE> x.Clear(); </CODE> <EM> Sets all bits of bitgenome x to 0          </EM><BR>
<CODE> x.Invert(); </CODE><EM> Inverts(toggles) all bits of bitgenome x   </EM><BR>
<CODE> x = a & b;  </CODE><EM> Bitwise AND of bitgenome a with bitgenome b  </EM> <BR>
<CODE> x = a | b;  </CODE><EM> Bitwise OR of bitgenome a with bitgenome b  </EM> <BR>
<CODE> x = a ^ b;  </CODE><EM> Bitwise XOR of bitgenome a with bitgenome b  </EM> <BR>
<CODE> x &= y;     </CODE><EM> Same as x = x & y </EM> <BR>
<CODE> x |= y;     </CODE><EM> Same as x = x</EM> | <EM> y </EM> <BR>
<CODE> x ^= y;     </CODE><EM> Same as x = x ^ y </EM> <BR>
<BR>

<STRONG> Changing the bitgenome size </STRONG><BR>
<CODE> x.Resize(8);     </CODE><EM> Replaces x with a new bitgenome of specified size.</EM><BR>
<CODE> x.ResizeSave(8); </CODE><EM> Replaces x with a new bitgenome of specified size. Copies 
                                    contents of previous bitgenome into new bitgenome.</EM> <BR>
<BR>
<STRONG> Binary and Grey code conversion </STRONG><BR>
<CODE> x.BinaryToGrey();  </CODE><EM> Interpret the bitgenome x as a binary code and convert x to grey code  </EM><BR>
<CODE> x.GreyToBinary();  </CODE><EM> Interpret the bitgenome x as a grey code and convert x  to binary code </EM><BR>
<CODE> ConvertBinaryToGrey(x, y); </CODE><EM> Replace y with grey code equivalent of binary coded x. </EM><BR>
<CODE> ConvertGreyToBinary(x, y); </CODE><EM> Replace y with binary code equivalent of grey coded x. </EM><BR>

<BR>


<STRONG> Randomizing the bits in the genome </STRONG><BR>
<CODE> x.Randomize(); </CODE><EM> Create a random bit pattern in the genome </EM><BR><BR>


<STRONG> Reproduction operators </STRONG><BR>
<CODE> x.Mutate( 0.3 ); </CODE><EM> Invert each bit of the genome with probability 0.3 </EM><BR><BR>
<CODE> OnePointCrossover(parent1, parent2, child1, child2);<BR> </CODE>
       <EM> Perform single point crossover on the parent genomes (parent1 and parent2) 
       and produce two child genomes (child1 and child2) </EM><BR>
<CODE> TwoPointCrossover(parent1, parent2, child1, child2);<BR> </CODE>
<EM> Perform two point crossover on the parent genomes (parent1 and parent2) 
       and produce two child genomes (child1 and child2) </EM><BR>
<CODE> UniformCrossover(parent1, parent2, child1, child2, 0.5);<BR> </CODE>
<EM> Perform uniform crossover on the parent genomes (parent1 and parent2) 
       and produce two child genomes (child1 and child2). The probability of exchanging genes
       is 0.5 </EM><BR>
<BR>

<STRONG> Printing the bitgenome </STRONG><BR> 
<CODE> x.Print(cout);      </CODE><EM> Print the bitgenome on the ostream. </EM> <BR>
<CODE> cout << x;          </CODE><EM> Print the bitgenome on the ostream. </EM> <BR><BR>

<STRONG> Saving and retrieving the object </STRONG><BR>
<CODE> SaveState(os, x); </CODE><EM> Save state of the bitgenome on ostream os.</EM> <BR>
<CODE> LoadState(is, x); </CODE><EM> Retrieve state of the bitgenome from istream is.</EM> <BR><BR>

<HR>

<EM>
 Copyright (c) 1994 Leslie Picardo 
 <A HREF="mailto:picardo@alpha.ces.cwru.edu"> (picardo@alpha.ces.cwru.edu)</A>  <BR>
 All rights reserved              
</EM>
<HR>



</BODY>
</HTML>


