//===========================================================================
// Copyright (c) 1995 Leslie Picardo.  All rights reserved
//===========================================================================
#include <iostream.h>
#include "EvGlobalLocal.h"
#include "StdRandom.h"

//===========================================================================
EvGlobalLocal::EvGlobalLocal(void)
 : fAvOfs("average"), fBestOfs("best")
{
  cout << "Global Local Search \n";
  cout << "Population size ? : ";      // Ask user for population size
  cin  >> fPopulationSize;             // Get population size

  fParentPopulation.Resize( fPopulationSize);   // Set the population sizes
  fChildPopulation.Resize( fPopulationSize);

  cout << "Number of generations ? :"; // Ask user for number of generations
  cin  >> fMaxGenerations;             // Get maximum number of generations

  cout << "Mutation probability ? :[0.0 - 1.0] ";    
  cin  >> fMutationProbability;

  cout << "Mutation variance ? :";     // Ask user for mutation variance
  cin  >> fMutationVariance;           // Get mutation variance

#if 0
  cout << "Show Graphics ? [1/0]:";
  cin  >> fGraphicsFlag;

  if( fGraphicsFlag ) 
    {
      fPV = new TPopulationView;
      fPV->View( fParentPopulation );
    }
#endif

}

//===========================================================================
void EvGlobalLocal::Initialize(void)
{
  fParentPopulation.Randomize();           // Randomize parent population
  fParentPopulation.Evaluate();

  fAvOfs   << fGeneration << " " << fParentPopulation.Average() 
                          << " " << fParentPopulation.StdDev() << "\n";
  fBestOfs << fGeneration << " " << fParentPopulation.Best()   << "\n"; 
}

//===========================================================================
void EvGlobalLocal::Reproduce(void)
{
  for (int i=0; i<fPopulationSize; i++)
    {
      // With probability fMutationProbability create a mutant child
      // otherwise just create a random individual.
      if( Probability(fMutationProbability) )
	{
	  // Create a child that is a mutant of the parent
	  
	  // first make the child to be a copy of the parent
	  fChildPopulation[i] = fParentPopulation[i];
	  // then mutate the child genome
	  fChildPopulation[i].Genome().Mutate(fMutationVariance);
	}
      else
        fChildPopulation[i].Randomize();
    }
}

//============================================================================
void EvGlobalLocal::Evaluate(void)
{
  fChildPopulation.Evaluate();
}

//============================================================================
void EvGlobalLocal::Select(void)
{
  for (int i=0; i<fPopulationSize; i++)
    {
      // If the child is better than the parent keep the child 
      if(fChildPopulation[i].Performance() >= fParentPopulation[i].Performance())
	fParentPopulation[i] = fChildPopulation[i];
    }

  fAvOfs   << fGeneration << " " << fParentPopulation.Average() 
                          << " " << fParentPopulation.StdDev() << endl;
  fBestOfs << fGeneration << " " << fParentPopulation.Best()   << endl; 

#if 0
  if(fGraphicsFlag) fPV->Update();
#endif

}






















