//====================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//====================================================================

#ifndef  __EvGLSelectionH__
#define  __EvGLSelectionH__

#include "EvAlgorithm.h"
#include "EvRealGenome.h"
#include "EvIndividual.h"
#include "EvPopulation.h"

//#include "populationview.h"

class  EvGLSelection : public EvAlgorithm
{
  public:
    EvGLSelection(void);
//   ~EvGLSelection(void) { delete fPV; }

    virtual void Initialize(void);
    virtual void Reproduce(void);
    virtual void Evaluate(void);
    virtual void Select(void);
    
  protected:
    int   fPopulationSize;
    double fMutationVariance;         // The mutation variance
    double fMutationProbability;      // The probability of mutation

    EvPopulation<EvIndividual<EvRealGenome> > fParentPopulation;
    EvPopulation<EvIndividual<EvRealGenome> > fChildPopulation;

    ofstream fAvOfs, fBestOfs;

    // Graphics
    //int fGraphicsFlag;
    //TPopulationView *fPV;  

};

#endif
