//====================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//====================================================================

#include <iostream.h>
#include "EvGLSelection.h"
#include "StdRandom.h"

//===========================================================================
EvGLSelection::EvGLSelection(void)
 : fAvOfs("average"), fBestOfs("best")
{
  cout << "Global-Local + Selection  \n";
  cout << "Population size ? : ";      // Ask user for population size
  cin  >> fPopulationSize;             // Get population size

  fParentPopulation.Resize( fPopulationSize );   // Set the population sizes
  fChildPopulation.Resize( fPopulationSize );

  cout << "Number of generations ? :"; // Ask user for number of generations
  cin  >> fMaxGenerations;             // Get maximum number of generations

  cout << "Mutation probability ? :[0.0 - 1.0] ";    
  cin  >> fMutationProbability;

  cout << "Mutation variance ? :";     // Ask user for mutation variance
  cin  >> fMutationVariance;           // Get mutation variance

#if 0
  cout << "Show Graphics ? [1/0]:";
  cin  >> fGraphicsFlag;

  if( fGraphicsFlag ) 
    {
      fPV = new TPopulationView;
      fPV->View( fParentPopulation );
    }
#endif

}

//===========================================================================
void EvGLSelection::Initialize(void)
{
  fParentPopulation.Randomize();           // Randomize parent population
  fParentPopulation.Evaluate();

  fAvOfs   << fGeneration << " " << fParentPopulation.Average() 
                          << " " << fParentPopulation.StdDev() << "\n";
  fBestOfs << fGeneration << " " << fParentPopulation.Best()   << "\n"; 
}

//===========================================================================
void EvGLSelection::Reproduce(void)
{
  for (int i=0; i<fPopulationSize; i++)
    {
      // With probability fMutationProbability create a mutant child
      // otherwise just create a random individual.
      if( Probability(fMutationProbability) )
	{
	  // Create a child that is a mutant of the parent
	  
	  // first make the child to be a copy of the parent
	  fChildPopulation[i] = fParentPopulation[i];
	  // then mutate the child genome
	  fChildPopulation[i].Genome().Mutate(fMutationVariance);
	}
      else
        fChildPopulation[i].Randomize();
    }
}

//============================================================================
void EvGLSelection::Evaluate(void)
{
  fChildPopulation.Evaluate();
}

//============================================================================
void EvGLSelection::Select(void)
{
  for (int i=0; i<fPopulationSize; i++)
    {
      // If the parent is better than the child keep the parent
      if( fParentPopulation[i].Performance() >= fChildPopulation[i].Performance() )
	fChildPopulation[i] = fParentPopulation[i];
    }

  fParentPopulation.SelectFitnessProportionate( fChildPopulation );

  fAvOfs   << fGeneration << " " << fParentPopulation.Average() 
                          << " " << fParentPopulation.StdDev() << endl;
  fBestOfs << fGeneration << " " << fParentPopulation.Best()   << endl; 


#if 0
  if(fGraphicsFlag) fPV->Update();
#endif

}





















