// ============================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
// ============================================================================

#ifndef __EvPopulationH__
#define __EvPopulationH__

#include "StdArray.h"

// ============================================================================
// Template class EvPopulation<ZZ> is an array of ZZ's( eg: EvIndividual)
// Class ZZ must have a default constructor.
// ============================================================================

template<class ZZ>
class EvPopulation : public StdArray<ZZ>
{
  public:
  // Constructors
  EvPopulation(int populationSize = 0);
  
  // StdArray functions are inherited
  
  void Randomize(void);
  void Evaluate(void);
  double Average(void);
  double StdDev(void);
  double Best(void);

  // Printing the population
  void Print(ostream& os) const;

  // Selection 
  void SelectFitnessProportionate( EvPopulation<ZZ>& source);
};


// Selection operators ....................................................
template<class ZZ> 
EvPopulation<ZZ> SelectFitnessProportionate( EvPopulation<ZZ>& source );

// Printing the population 
template<class ZZ> ostream& operator << ( ostream&, const EvPopulation<ZZ>&);  

// Saving and retrieving the state of the population
template<class ZZ> void LoadState(istream&,  EvPopulation<ZZ>& );
template<class ZZ> void SaveState(ostream&,  EvPopulation<ZZ>& );
template<class ZZ> void LoadState(ifstream&, EvPopulation<ZZ>& );
template<class ZZ> void SaveState(ofstream&, EvPopulation<ZZ>& );


#endif




