//============================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//============================================================================

#ifndef __EvIndividualH__
#define __EvIndividualH__

#include <fstream.h>

// ===========================================================================
// Template class EvIndividual<ZZ>.   class ZZ is the genome.
// ===========================================================================

template<class ZZ>
class EvIndividual             
{
 public:
  // Constructor
  EvIndividual(void); 

  void Randomize(void);
  void Evaluate(void);
    
  // Access to data
  inline double  Performance(void) const; // The performance of this individual
  inline double& Performance(void);      
  inline double  Fitness(void) const;     // The fitness of this individual
  inline double& Fitness(void);

  inline const ZZ& Genome(void) const;   // Return a reference to the genome
  inline       ZZ& Genome(void);   

  // Printing the individual
  void Print(ostream&) const;            

  // Saving and retrieving the state of the individual
  friend void LoadState(istream&, EvIndividual<ZZ>& );
  friend void SaveState(ostream&, EvIndividual<ZZ>& );

 private:
  ZZ      fGenome;         // Every individual has a genome
  double  fPerformance;    // Performance value of individual 
  double  fFitness;        // Fitness of the individual 
};


// Non-member functions  .....................................................
template<class ZZ> ostream& operator << ( ostream&, const EvIndividual<ZZ>& );

// Saving and retrieving the state of the individual
template<class ZZ> void LoadState(ifstream&, EvIndividual<ZZ>& );
template<class ZZ> void SaveState(ofstream&, EvIndividual<ZZ>& );


// Inlines ...................................................................
template<class ZZ> 
inline double EvIndividual<ZZ>::Performance(void) const { return (fPerformance);}

template<class ZZ> 
inline double& EvIndividual<ZZ>::Performance(void) { return (fPerformance);}

template<class ZZ> 
inline double  EvIndividual<ZZ>::Fitness(void) const { return (fFitness); }

template<class ZZ> 
inline double& EvIndividual<ZZ>::Fitness(void)       { return (fFitness); }
    
template<class ZZ> 
inline const ZZ& EvIndividual<ZZ>::Genome(void) const { return (fGenome); }

template<class ZZ> 
inline       ZZ& EvIndividual<ZZ>::Genome(void)       { return (fGenome); }  

#endif






