//===========================================================================
// Copyright (c) 1995 Leslie Picardo.  All rights reserved
//===========================================================================

#ifndef __EvBitGenomeH__
#define __EvBitGenomeH__

#include "StdBitString.h"

//===========================================================================
// A EvBitGenome is a genome in which each gene is a bit
//===========================================================================

class EvBitGenome : public StdBitString
{
  public:
    // Constructors
    EvBitGenome(int numberOfBits = 1);
    EvBitGenome(const StdBitString&);

    // StdBitString functions are public
    
    // Randomize the bits in the genome
    void Randomize(void);
    
    // Mutation
    void  Mutate(float probability );
};


// Crossover operators .......................................................
void
OnePointCrossover(const EvBitGenome& parent1, const EvBitGenome& parent2,
                        EvBitGenome& child1,        EvBitGenome& child2 );
void
TwoPointCrossover(const EvBitGenome& parent1, const EvBitGenome& parent2,
                        EvBitGenome& child1,        EvBitGenome& child2 );
void
UniformCrossover(const EvBitGenome& parent1, const EvBitGenome& parent2,
                       EvBitGenome& child1,        EvBitGenome& child2,
                       float probability );

// Non-member functions ......................................................

// Printing the genome
ostream& operator << (ostream& os, const EvBitGenome& g);

// Saving and retrieving the state of the genome
void LoadState(istream&, EvBitGenome& );
void SaveState(ostream&, EvBitGenome& );


#endif
