//====================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//====================================================================

#ifndef  __EvAlgorithmH__
#define  __EvAlgorithmH__

//====================================================================
// Abstract base class for any evolutionary algorithm
//====================================================================


class EvAlgorithm
{
  public:
    EvAlgorithm(void);
    virtual ~EvAlgorithm(void) { }
  
    virtual void Initialize(void) = 0;  
    virtual void Reproduce(void)  = 0;
    virtual void Evaluate(void)   = 0;
    virtual void Select(void)     = 0;
    virtual int  Terminated(void);      

    virtual void Execute(void);
    virtual void Reset(void); 
    virtual void End(void) {}

  protected:
    int fGeneration;       // generation counter
    int fMaxGenerations;   // number of generations before termination
};


#endif
