//====================================================================
// Copyright (c) 1995 Leslie Picardo.  All rights reserved
//====================================================================

#include "EvAlgorithm.h"
#include "StdRandom.h"

extern "C" int getpid();

// EvAlgorithmAlgorithm is an abstract class that describes the 
// the operation of any evolutionary algorithm. Each algorithm Initialize's
// itself and runs for a number of <fGeneration>'s. At each generation
// the algorithm Execute's  a sequence of operations; Reproduce, Evaluate,
// and Select. At the end of <fMaxGenerations> the algorithm terminates.




//====================================================================
EvAlgorithm::EvAlgorithm(void)
{
  fGeneration     = 0;       // Begin at the 0th generation
  fMaxGenerations = 1;       // Default max number of generations

  // Seed the random generator
  //int seed; cout << "Random generator seed: "; cin >> seed;
  int seed = getpid();
  ofstream ofs("seed");  ofs << seed; ofs.close();  // Save the seed
  RandomSeed( seed );   // Seed the random generator
}


//====================================================================
int EvAlgorithm::Terminated(void)
{
  // Test for algorithm termination.

  fGeneration++;    // consider the next  generation

  if ( ( fGeneration <= fMaxGenerations ) )
    {   return (0);  }        // The search is still in process
  else
    {   return (1);  }        // The search has terminated
} 


//====================================================================
void EvAlgorithm::Execute(void)
{
  // Generalized execution loop for any evolutionary algorithm

  Initialize();          
  while( !Terminated())
    {
      Reproduce();       
      Evaluate();        
      Select();          
    }
  End();
}

//====================================================================
void EvAlgorithm::Reset(void) { fGeneration = 0; }








