<!DOCTYPE HTML SYSTEM "html.dtd">
<HTML><HEAD><TITLE> examples: EvRealGenome </TITLE></HEAD>
<BODY> 

<H3> Examples: </H3>
 
<PRE> #include "EvRealGenome.h" </PRE> 

<STRONG> Constructors </STRONG><BR>
 <CODE> EvRealGenome  g(5);</CODE><EM> Creates a genome g with 5 uninitialized real numbers.  </EM> <BR>
 <CODE> EvRealGenome  g;     </CODE><EM> Creates a genome h with 0(default size) real numbers. </EM> <BR>
 <CODE> EvRealGenome  h(g);  </CODE><EM> Creates a copy of genome g. </EM> <BR>
 <CODE> EvRealGenome  j = g; </CODE><EM> Creates a copy of genome g. </EM> <BR>
 <CODE> h = g;  </CODE><EM> Assigns genome g to genome h.    </EM> <BR><BR>


<STRONG> Access to data </STRONG><BR>
<CODE> int n = g.Size();  </CODE><EM> Gets the size (number of elements) of genome g. </EM> <BR>
<CODE> double x = g[i];   </CODE><EM> Reads i'th element of genome g. </EM> <BR>
<CODE> g[i] = 3.14;   </CODE><EM> Writes to i'th element of genome g.   </EM> <BR><BR>

<STRONG> Changing the genome size </STRONG><BR>
<CODE> g.Resize(20);          </CODE><EM> Resizes genome g to specified size. Elements of g are uninitialized.</EM> <BR>
<CODE> g.ResizeSave(20);      </CODE><EM> Resizes genome g to specified size. Elements of previous genome are copied
over to resized genome. If genome is lengthened then the excess elements remain uninitialized. </EM> <BR><BR>

<STRONG>  Randomizing the genes </STRONG><BR>
<CODE> g.Randomize(-5.0, 5.0); </CODE><EM> Randomize each element uniformly in the interval [-5.0, 5.0] </EM> <BR>
<CODE> g.Randomize(); </CODE><EM> Randomize each gene uniformly in the (default) interval [-1.0, 1.0] </EM> <BR>
<BR>

<STRONG> Reproduction operators </STRONG><BR>
<CODE> g.Mutate( 1.0, 0.2); </CODE><EM> Add a random vector to the genome. <BR>The magnitude of the vector
              is a gaussian random variable with variance 1.0 and mean 0.2 </EM> <BR>
<CODE> g.Mutate( 1.0 ); </CODE><EM> Add a random vector to the genome. <BR>The magnitude of the vector
              is a gaussian random variable with variance 1.0 and (default) mean 0.0 </EM> <BR><BR>

<EM> Crossover genomes parent1 and parent2 to generate genomes child1 and child2 </EM><BR>
<CODE> OnePointCrossover(parent1, parent2, child1, child2);</CODE>
       <EM> Perform single point crossover. </EM><BR>
<CODE> TwoPointCrossover(parent1, parent2, child1, child2);</CODE>
       <EM> Perform two point crossover. </EM><BR>
<CODE> UniformCrossover(parent1, parent2, child1, child2, 0.5);</CODE>
      <EM> Perform uniform crossover. The probability of exchanging genes is 0.5 </EM><BR><BR>


<STRONG> Printing the realgenome </STRONG><BR> 
<CODE> g.Print(cout);      </CODE><EM> Print each element of genome g on ostream. </EM> <BR>
<CODE> cout << g;          </CODE><EM> Print each element of genome g on ostream. </EM> <BR><BR>

<STRONG> Saving and retrieving the object </STRONG><BR>
<CODE> SaveState(os, g);  </CODE><EM> Save state of genome g on ostream os.</EM> <BR> 
<CODE> LoadState(is, g);  </CODE><EM> Retrieve state of genome g from istream is.</EM> <BR><BR>

<STRONG> Vector math operations </STRONG><BR>

<CODE> g += h; </CODE><EM> Vector addition of genome h to genome g </EM> <BR> 
<CODE> g -= h; </CODE><EM> Vector subtraction of genome h from genome g </EM> <BR> 
<CODE> g *= 3.14; </CODE><EM> Multiply each element of genome g by 3.14  </EM> <BR> 
<CODE> g /= 3.14; </CODE><EM> Divide each element of genome g by 3.14  </EM> <BR>
<CODE> j = h + g; </CODE><EM> Vector addition of genome h and genome g </EM> <BR>
<CODE> j = h - g; </CODE><EM> Vector subtraction of genome g from genome h </EM> <BR>
<CODE> h = g * 3.14 </CODE><EM> Scalar multiplication of genome g with 3.14  </EM> <BR>
<CODE> h = g / 3.14 </CODE><EM> Scalar division of genome g with 3.14  </EM> <BR>
<CODE> double x = h * g </CODE>  <EM>Vector multiplication of genome h with genome g</EM> <BR>

<HR>

<EM>
 Copyright (c) 1995 Leslie Picardo 
 <A HREF="mailto:picardo@alpha.ces.cwru.edu"> (picardo@alpha.ces.cwru.edu)</A>  <BR>
 All rights reserved              
</EM>
<HR>



</BODY>
</HTML>


