#include <stdio.h>
#include <math.h>
#include "general.h"
#include "thin.h"

/***********************************************************
 Function that thins all possible points in an image in the
 given bounds.
 There are two versions: thin_image() and thin_image_copy();
 the only difference is that thin_image() thins the input
 image, and thin_image_copy() thins the image but puts the
 result in an output image.
 A brief description of the parameters and functionality is
 above in the function delete_point_for_thinning.
Author: Fabio Cozman
Date: 10-23-94
************************************************************/

int thin_image(FG_Image *image_lines, FG_Subimage bounds, 
	       int flag_analysis, int verbose)
{ 
register int i, j;
register int center, n, s, w, e, ne, nw, se, sw;
int counter = 0;
int rs, re, cs, ce;

rs = bounds.rs + 1; re = bounds.re - 1; 
cs = bounds.cs + 1; ce = bounds.ce - 1;
for (i = rs; i < re; i++)
  for (j = cs; j < ce; j++) {
      center = fg_i_igetpixel(image_lines, i, j); 
      if (center != 0) {
	n = fg_i_igetpixel(image_lines, i-1, j);
	s = fg_i_igetpixel(image_lines, i+1, j);
	w = fg_i_igetpixel(image_lines, i, j-1);
	e = fg_i_igetpixel(image_lines, i, j+1);
	ne = fg_i_igetpixel(image_lines, i-1, j+1);
	nw = fg_i_igetpixel(image_lines, i-1, j-1);
	se = fg_i_igetpixel(image_lines, i+1, j+1);
	sw = fg_i_igetpixel(image_lines, i+1, j-1);
	if (delete_point_for_thinning(flag_analysis, n,s,e,w,ne,nw,se,sw)) {
	  fg_i_iputpixel(image_lines, i, j, 0);
	  counter++;
	}
      }
    }
if (verbose) printf(" Done with %d deletions! ", counter); 
return(counter);
}

/********************************************************************/

int thin_image_copy(FG_Image *image_lines, FG_Image *image_thin,
		    FG_Subimage bounds, 
		    int flag_analysis, int verbose)
{ 
register int i, j;
register int center, n, s, w, e, ne, nw, se, sw;
int counter = 0;
int rs, re, cs, ce;

rs = bounds.rs + 1; re = bounds.re - 1; 
cs = bounds.cs + 1; ce = bounds.ce - 1;
for (i = rs; i < re; i++)
  for (j = cs; j < ce; j++) {
      center = fg_i_igetpixel(image_lines, i, j); 
      if (center != 0) {
	n = fg_i_igetpixel(image_lines, i-1, j);
	s = fg_i_igetpixel(image_lines, i+1, j);
	w = fg_i_igetpixel(image_lines, i, j-1);
	e = fg_i_igetpixel(image_lines, i, j+1);
	ne = fg_i_igetpixel(image_lines, i-1, j+1);
	nw = fg_i_igetpixel(image_lines, i-1, j-1);
	se = fg_i_igetpixel(image_lines, i+1, j+1);
	sw = fg_i_igetpixel(image_lines, i+1, j-1);
	if (delete_point_for_thinning(flag_analysis, n,s,e,w,ne,nw,se,sw)) {
	  fg_i_iputpixel(image_thin, i, j, 0);
	  counter++;
	}
	else fg_i_iputpixel(image_thin, i, j, 1);
      }
      else fg_i_iputpixel(image_thin, i, j, 0);
    }
if (verbose) printf(" Done with %d deletions! ", counter); 
return(counter);
}

/************************************************************
 Function that analyses one pixel and decides whether or not
 it should be deleted. Returns 1 if the pixel may be deleted,
 0 otherwise.

 Uses the definition of SIMPLE points given by Martial
 in the Computer Vision class (and rather cumbersome way
 of verifying when a pixel is simple). Basically a 
 non-simple pixel cannot be deleted because it is 
 connecting several regions.

 Flag_analysis is rather subtle: if it is one, a terminal
 point is a point that has only one neighbor; if it is zero,
 a terminal point is a point that is inside a L formed by
 other points. Flag_analysis equal to 1 tends to delete more
 pixels. In order to see why, see the following situation:
                     + + +
	             - + -
                     - - -
 where + represents a non-background pixel and - represents
 a background pixel. The central point is not a terminal 
 point in the first sense, because it has three neighbors
 (so it would be deleted), but it is not a terminal point
 in the second sense (so it would not be deleted).

Author: Fabio Cozman
Date: 9-17-93
************************************************************/

int delete_point_for_thinning(register int flag_analysis, 
			      register int n,  register int s,
			      register int e,  register int w,
			      register int ne, register int nw,
			      register int se, register int sw)
{
/******* Non-simple points cannot be deleted: *********/
if ( ( ( n != 0 ) && ( s != 0 ) && ( e == 0 ) && ( w == 0 ) ) || 
     ( ( n == 0 ) && ( s == 0 ) && ( e != 0 ) && ( w != 0 ) ) ||
     ( ( e == 0 ) && ( s == 0 ) && ( se != 0 ) ) ||
     ( ( w == 0 ) && ( s == 0 ) && ( sw != 0 ) ) ||
     ( ( e == 0 ) && ( n == 0 ) && ( ne != 0 ) ) ||
     ( ( w == 0 ) && ( n == 0 ) && ( nw != 0 ) ) ||
     ( ( s == 0 ) && ( n == 0 ) && ( e == 0 ) && ( w == 0 ) && 
       ( sw == 0 ) && ( se == 0 ) && ( nw == 0 ) && ( ne == 0 ) ) ) return (0);

if (flag_analysis) {
  /********* Terminal points cannot be deleted (terminal in strong sense) **/
  if ( (  ( n != 0 ) + ( s != 0 ) + ( e != 0 ) + ( w != 0 ) +
        ( ne != 0 ) + ( nw != 0 ) + ( se != 0 ) + ( sw != 0 )  ) == 1 )
    return(0);
  else
    return(1);
}
else {
  /******** Non-terminal (in the weak sense) points must be deleted: *******/
  if ( ( ( e != 0 ) && ( s != 0 ) ) || ( ( e != 0 ) && ( n != 0 ) ) || 
      ( ( w != 0 ) && ( s != 0 ) ) || ( ( w != 0 ) && ( n != 0 ) ) ) 
    return(1);
  else
    return(0);  
}
}







