/*****************************************
Program that manages linked list.
******************************************
History:
 * 23-Sep-93 Fabio G. Cozman begins
******************************************/
 
#include <stdio.h>
#include <stdlib.h>
#include "general.h"
#include "linked.h"


/***************************************************************
 Creates a single node from data; returns pointer to node.
Author: Fabio Cozman
Date: 9-20-93
***************************************************************/

NodeLinked *create_linked_list_node(Data data)
{
NodeLinked *new_node;
static number_of_nodes = 0;

number_of_nodes++;
if ( (new_node = (NodeLinked *)malloc( sizeof(NodeLinked) )) == NULL ) 
  error("create_linked_list_node", 0);
new_node->number_of_node = number_of_nodes;
new_node->father = new_node->child = NULL;
new_node->data = data;
return(new_node);
}

/***************************************************************
 Reverses a linked list.
Author: Fabio Cozman
Date: 9-20-93
***************************************************************/

void reverse_linked_list(LinkedList *list)
{
NodeLinked *node, *aux_node;
if ( list == NULL ) error("reverse_linked_list", 1);
if ( list->first_node == NULL ) return;
node = list->first_node;
if ( node->child == NULL ) return;

node->father = node->child;
aux_node = node->child;
node->child = NULL;

reverse_linked_node(aux_node, node);

aux_node = list->first_node;
list->first_node = list->last_node;
list->last_node = aux_node;
}

/*************************************************************
 Reverses node.
Author: Fabio Cozman
Date: Feb 1 94
*************************************************************/

void reverse_linked_node(NodeLinked *node, NodeLinked *father)
{
NodeLinked *aux_node;

if (node == NULL) return;
node->father = node->child;
aux_node = node->child;
node->child = father;

reverse_linked_node(aux_node, node);
}

/***************************************************************
 Frees a whole linked list from a given node.
Author: Fabio Cozman
Date: 9-20-93
***************************************************************/

void free_linked_list(LinkedList *list)
{
if (list == NULL) return;
if (list->first_node == NULL) { free(list); return; }
free_linked_list_node(list->first_node);
free(list);
}

/***************************************************************
 Frees from a node on.
Author: Fabio Cozman
Date: 9-20-93
***************************************************************/

void free_linked_list_node(NodeLinked *node)
{
if (node == NULL) return;
free_linked_list_node(node->child);
free(node);
}

/***************************************************************
 Frees a whole linked list from a given node (also frees data).
Author: Fabio Cozman
Date: Mar 6 94
***************************************************************/

void free_linked_list_and_data(LinkedList *list)
{
if (list == NULL) return;
if (list->first_node == NULL) { free(list); return; }
free_linked_list_node_and_data(list->first_node, 0);
if (list == NULL) exit(0);
free(list);
}

/***************************************************************
 Frees from a node on (also frees data).
Author: Fabio Cozman
Date: Mar 6 94
***************************************************************/

int free_linked_list_node_and_data(NodeLinked *node, int aux)
{
if (node == NULL) return(0);
aux = free_linked_list_node_and_data(node->child, aux);
free(node->data);
free(node);
return(aux + 1);
}

/***************************************************************
 Prints a list from given node.
Author: Fabio Cozman
Date: 9-20-93
***************************************************************/

void print_linked_list(LinkedList *list, void (*print_data)())
{
NodeLinked *node, *child_node1, *child_node2;

if (list == NULL) error("print_linked_list", 0);
if (list->first_node == NULL)
  {  printf("\n\n List is empty!");  return; }
node = list->first_node;
printf("\n List %d with %d nodes from %d to %d", 
       list->id, list->number_of_nodes, 
       list->first_node->number_of_node, list->last_node->number_of_node);
printf("\n Root is node %d", node->number_of_node);
print_linked_list_node(node, print_data);
child_node1 = node->child;
while (child_node1 != NULL) {
  child_node2 = child_node1->child;
  print_linked_list_node(child_node1, print_data);
  child_node1 = child_node2;
}
}

void print_linked_list_aux(LinkedList *list)
{
NodeLinked *node, *child_node1, *child_node2;

if (list == NULL) error("print_linked_list", 0);
if (list->first_node == NULL)
  {  printf("\n\n List is empty!");  return; }
node = list->first_node;
printf("\n List %d with %d nodes from %d to %d", 
       list->id, list->number_of_nodes, 
       list->first_node->number_of_node, list->last_node->number_of_node);
printf("\n Root is node %d", node->number_of_node);
printf(" with data: %d",  *((int *)(node->data)));
child_node1 = node->child;
while (child_node1 != NULL) {
  child_node2 = child_node1->child;
  printf("\n Node %d", node->number_of_node);
  printf(" with data: %d",  *((int *)(node->data)));
  child_node1 = child_node2;
}
}

/***************************************************************
 Prints a node.
Author: Fabio Cozman
Date: 9-20-93
***************************************************************/

void print_linked_list_node(NodeLinked *node, void (*print_data)())
{
if (node == NULL) return;
printf("\n Node %d with data:  ", node->number_of_node);
print_data(node->data);
}

/**************************************************************
 Inserts data in a list in a unsorted (and fast) way. 
 Variable TO_END indicates whether data must be appended to
 the last node (if TO_END is 1) or must precede first node
 (if TO_END is 0).
Author: Fabio Cozman
Date: Oct 13 93
**************************************************************/

void insert_unsorted_linked_list(LinkedList *list, Data data, int to_end)
{
NodeLinked *node;
if ( (node = create_linked_list_node(data)) == NULL )
  error("insert_unsorted_linked_list", 0);
if (list->first_node == NULL) {
  list->first_node = list->last_node = node;
}
else {
  if (to_end) {
    list->last_node->child = node;
    node->father = list->last_node;
    list->last_node = node;
  }
  else {
    list->first_node->father = node;
    node->child = list->first_node;
    list->first_node = node;
  }
}
(list->number_of_nodes)++;
}

/************************************************************************
 Function that deletes the first or last node, depending on the value
 of the variable to_end.
Author: Fabio Cozman
Date: Feb 25 94
************************************************************************/

void delete_extremity_unsorted_linked_list(LinkedList *list, int to_end)
{
NodeLinked *node;

 /*************** ERROR HANDLING ************/
if (list == NULL) error("linked.c", 1);

if (to_end) {
  node = list->last_node->father;
  node->child = NULL;
  free(list->last_node);
  list->last_node = node;
}
else {
  node = list->first_node->child;
  node->father = NULL;
  free(list->first_node);
  list->first_node = node;
}
list->number_of_nodes--;
}

