/*****************************************
  General functions used in my programs.
    Fabio Cozman
Date: Feb 1 94
*****************************************/

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "general.h"
 
/********************************************
 This function is the error handler.
Author: Fabio Cozman
Date: Oct 13 93
*********************************************/

void error(char *message, int number)
{
printf("\n Problem number %d in function %s! Exiting... \n\n",
      number, message);
exit(number);
}

/*****************************************************
Here is a different version stolen from
/tmp_mnt/IUS/SHARE/src/vision/src/libcs/quit.c:
#include <stdio.h>
#include <varargs.h>
void error(message, number, va_alist)
char *message;
int number;
va_dcl
{
        va_list args;     fflush(stdout);     va_start(args);
        (void) vfprintf(stderr, message, args);
        va_end(args);    exit(number);
}
**********************************************/

/*********************************************************
 Functions that call the GIL library functions.
Author: Fabio Cozman
Date: September 12 94
*********************************************************/

int fg_i_rstart(FG_Image *image) 
{ return(i_rstart(image)); }

int fg_i_rend(FG_Image *image) 
{ return(i_rend(image)); }

int fg_i_cstart(FG_Image *image) 
{ return(i_cstart(image)); }

int fg_i_cend(FG_Image *image) 
{ return(i_cend(image)); }

FG_Image *fg_i_open(char *name, int flag, int *error)
{ return(i_open(name, flag, error)); }

FG_Image *fg_i_newimat(FG_Subimage bounds, int *error)
{ return(i_newimat(bounds, error)); }

FG_Image *fg_i_newfmat(FG_Subimage bounds, int *error)
{ return(i_newfmat(bounds, error)); }

void fg_i_copy(FG_Image *image_in, FG_Image *image_out, int value, int *error)
{ i_copy(image_in, image_out, value, error); }

void fg_i_close(FG_Image *image, int *error)
{ i_close(image, error); }

void fg_i_clrimg(FG_Image *image)
{ i_clrimg(image); }

void fg_i_iputpixel(FG_Image *image, int x, int y, int value)
{ i_iputpixel(image, x, y, value); }

void fg_i_fputpixel(FG_Image_float *image, int x, int y, float value)
{ i_fputpixel(image, x, y, value); }

int fg_i_igetpixel(FG_Image *image, int x, int y)
{ return(i_igetpixel(image, x, y)); }

float fg_i_fgetpixel(FG_Image_float *image, int x, int y)
{ return(i_fgetpixel(image, x, y)); }

void fg_i_line(FG_Image *image, float x1, float y1, float x2, float y2,
               int *value)
{ i_line(image, x1, y1, x2, y2, IM_INT, (generic_pointer)value); }



