/* Include file for Linker5 Program */

#define CHAIN 1
#define CONNECTION 2
#define GHOST_CONNECTION 3
#define FILTER_CHAIN 4

#define NORTH      1
#define SOUTH      2
#define EAST       3
#define WEST       4
#define NORTH_EAST 5
#define NORTH_WEST 6
#define SOUTH_EAST 7
#define SOUTH_WEST 8
#define NO_DIRECTION -1

#define TO_START 0
#define TO_END 1

struct element {
  int id;
  int type;
  Data data;
};
typedef struct element Element;

struct elements {
  int total;
  int max;
  Element *elements;
};
typedef struct elements Elements;

struct connection {
  int x, y;
  int size;
  int number_connected_chains;
  int number_processed_chains;
  int *connected_chains;
};
typedef struct connection Connection;

struct chain {
  int xs, ys;
  int ds;
  int xe, ye;
  int de;
  int first_chain_start, second_chain_start;
  int first_chain_end, second_chain_end;
  int length, intensity_summation;
  LinkedList *lines;
};
typedef struct chain Chain;

struct line {
  int n;
  float to, tf;
  float a, b;
  float sigma_a, sigma_b, cov_ab;
  float c, d;
  float sigma_c, sigma_d, cov_cd;
  float St, Stt, Sxt, Syt;
  float Sx, Sxx, Sy, Syy;
  float residual_ab, residual_cd;
};
typedef struct line Line;

struct image_point { int x, y; };
typedef struct image_point ImagePoint;

struct filter_line {
  float xo, yo, xf, yf;
  float A, B, C;
};
typedef struct filter_line FilterLine;

struct filter_chain {
  int xs, ys;
  int ds;
  int xe, ye;
  int de;
  int previous, next;
  int length, intensity_summation;
  int number_of_lines;
  FilterLine *filter_lines;
};
typedef struct filter_chain FilterChain;
  
/* Function Prototypes */

void initialize_chains_connections(Elements *chains, Elements *connections,
                                   int max_elements);

void linking(FG_Image *image_in, FG_Image *image_out, FG_Image *image_chains, 
	     FG_Subimage bounds, 
	     Elements *chains, Elements *connections,
	     float variance_of_pixel, int significance_level_break_lines);
void glue_chains(FG_Image *image_in, FG_Image *image_out, 
		 FG_Image *image_chains, FG_Subimage bounds, 
		 Elements *chains, Elements *connections, 
		 float variance_of_pixel, int size_exploration);
void explore_extremity(FG_Image *image_out, FG_Image *image_chains, 
		       FG_Subimage bounds, 
		       Elements *chains, Elements *connections,
		       Chain *aux_chain, int aux_index, int connection_index, 
		       float variance_of_pixel, int to_end, 
		       int size_exploration, int *connection_marks);
int explore_gap(FG_Image *image_out, FG_Subimage bounds, 
		Elements *chains, Elements *connections, 
		Chain *aux_chain, int aux_index, int to_end, 
		int size_exploration, int *connection_marks);
void chain_in_gap_exploration(Elements *chains, Elements *connections, 
			      LinkedList *extremities_of_connection, 
			      int temp_pixel, int i, int j);
void connection_in_gap_exploration(Elements *chains, Elements *connections, 
				   LinkedList *marked_connections,
				   LinkedList *extremities_of_connection, 
			   int *connection_marks,
				   int temp_pixel, 
				   int is, int il, int js, int jl);
void handle_ghost_connection(Elements *connections, Chain *aux_chain, 
			     LinkedList *extremities_of_connection, 
			     int temp_i, int temp_j);
int continue_connection(FG_Image *image_out, FG_Image *image_chains, 
			FG_Subimage bounds, 
			Elements *chains, Elements *connections, 
			int chain_index, int connection_index, 
			float variance_of_pixel, 
			int *p_to_end, Line *minimum_line, 
			int size_exploration);
Line *x_y_d_n_line(Chain *temp_chain, 
		    int *p_x, int *p_y, int *p_d, int *p_n, int to_end);
int find_status_of_other_chain(Chain *other_chain, int connection_index);
int find_status_jump_gaps(Chain *other_chain, Connection *connection, 
			  int index_connection);
void residual_pair_of_lines(FG_Image *image_out, FG_Image *image_chains, 
			    FG_Subimage bounds, Line *composed_line, 
			    int x, int y, int d, int n, 
			    float variance_of_pixel, int to_end);
void follow(FG_Image *image_in, FG_Image *image_out, FG_Image *image_chains, 
	    FG_Subimage bounds, 
	    Elements *chains, Elements *connections, 
	    Chain *temp_chain, int id_chain, int i, int j, 
	    int direction, int previous_direction,
	    float variance_of_pixel, int significance_level_break_lines, 
	    int to_end);
void fill_to_end(Chain *temp_chain, int x, int y, int direction, int to_end);
int labelline(FG_Image *image_in, FG_Image *image_out, FG_Image *image_chains, 
	      FG_Subimage bounds, 
	      int startx, int starty, int label, int cnt, int id_chain, 
	      int *number_connected_chains, 
	      LinkedList *extremities_of_connection);
int continue_connection_test(FG_Image *image_in, FG_Image *image_out, 
			     FG_Image *image_chains, FG_Subimage bounds,
			     int x, int y, int id_chain, 
			     int *number_connected_chains,
			     LinkedList *extremities_of_connection);
void update_line(Line *line, int x_in, int y_in, 
		 float variance_of_pixel, int to_end);
void connect_one(Elements *connections, Chain *temp_chain, 
		 int index_connection_to, int index_chain, int to_end);
Chain *create_chain(Elements *chains, int i, int j);
Line *create_line(void);
void copy_line(Line *line_from, Line *line_to);
void handle_connection(FG_Image *image_in, FG_Image *image_out, 
		       FG_Image *image_chains, FG_Subimage bounds,
		       Elements *connections, 
		       int buf_connections[], int number_connections, 
                       int i, int j, int id_chain);
void verify_whether_closed_curve(Chain *chain, int id_chain);
void next_one(int *p_next_i, int *p_next_j, int direction);
void increment_total_elements(Elements *elements);
int print_chain(Elements *chains, int number_chain, int verbose);
void print_chain_simple(Chain *temp_chain);
void print_filter_chain(FilterChain *filtered_chain);
void print_line(Line *line);
int print_connection(Elements *connections, 
		     int number_connection, int verbose);
void print_connection_simple(Connection *temp_connection);
void print_element(Element *temp_element);
void draw_line(FG_Image *image, Line *line, int value);
void draw_filter_line(FG_Image *image, FilterLine *filter_line, int value);
void draw_chain(FG_Image *image, Chain *chain, int value);
void draw_filter_chain(FG_Image *image, FilterChain *filter_chain, int value);
int status_of_pixel(FG_Image *image_in, FG_Image *image_out, 
		    FG_Image *image_chains, FG_Subimage bounds,
		    int *number_unexplored, int *number_connections,
		    int buf_unexplored[], int buf_connections[], 
		    int i, int j, int id_chain);
int analyse_pixel_value(int value, int direction, 
                        int *number_unexplored, int *number_connections, 
                        int buf_unexplored[], int buf_connections[],
                        int id_chain);
int give_direction(int i1, int j1, int i2, int j2);
int query_number_bits(int binary_number);
int query_chain_connection(int chain_code);
int first_available_direction_in_chain_code(int chain_code);
int all_available_directions_in_chain_code(int chain_code, 
					   int buf_directions[8]);
int invert_direction(int direction);
void free_chains_connections(Elements *chains, Elements *connections);
void free_elements(Elements *vector_elements);
void filter_all_chains(Elements *chains, Elements *filter_chains);
void transfer_from_chain_to_filter_chain(Chain *chain, 
					 FilterChain *temp_filter_chain);
void transfer_pointers_to_previous_and_next_chains(Chain *chain, 
					   FilterChain *temp_filter_chain);
void transfer_line_contents(Line *line, FilterLine *filtered_line);
