/***********************************************
  * Include file for linked list manipulations 
  * as programmed in linked.c.
Author: Fabio Cozman
Date: 10-1-93
************************************************/

/** Definition of NodeLinked ****/

struct nodelinked {
  int number_of_node;
  struct nodelinked *father;
  struct nodelinked *child;
  Data data;
};
typedef struct nodelinked NodeLinked;

/** Definition of LinkedList ****/

struct linkedlist {
  int id;
  int number_of_nodes;
  NodeLinked *first_node;
  NodeLinked *last_node;
};
typedef struct linkedlist LinkedList;

/**** Function Prototypes *********/

NodeLinked *create_linked_list_node(Data data);

void reverse_linked_list(LinkedList *list);

void reverse_linked_node(NodeLinked *node, NodeLinked *father);

void free_linked_list(LinkedList *list);

void free_linked_list_and_data(LinkedList *list);

void free_linked_list_node(NodeLinked *node);

int free_linked_list_node_and_data(NodeLinked *node, int aux);

void print_linked_list(LinkedList *list, void (*print_data)());

void print_linked_list_aux(LinkedList *list);

void print_linked_list_node(NodeLinked *node, void (*print_data)());

void insert_unsorted_linked_list(LinkedList *list, Data data, int to_end);

void delete_extremity_unsorted_linked_list(LinkedList *list, int to_end);

/*** UNTESTED FUNCTIONS *****
NodeLinked *member_unsorted_linked_list( );
NodeLinked *member_sorted_linked_list( );
NodeLinked *insert_sorted_linked_list( );
NodeLinked *insert_linked_list_node( );
NodeLinked *delete_sorted_linked_list( );
NodeLinked *delete_unsorted_linked_list( );
void delete_linked_list_node( );
*****************************/

