#!/usr/local/bin/perl

#This perl script translates a Mathematica file (written in a somewhat
#standardized manner) into a LaTeX file ready to be compiled.
#Author: Fabio Cozman

print "\\documentstyle[12pt]{article} \n";
print "\\setlength{\\textheight}{20cm} \n";
print "\\setlength{\\textwidth}{16.5cm} \n";
print "\\setlength{\\oddsidemargin}{0cm} \n";
print "\\setlength{\\evensidemargin}{0cm} \n";
print "\\begin{document} \n";

while (<>) {
  if (($Text) = /\(\*+([^\*]*)\*/) { &printtext( "$Text \n" , "" );
	if (/\\author/) { print "\\maketitle \n \\tableofcontents \n" ; } } 
  elsif (/^\n/) { print "\n"; } 
  elsif (($Name,$Start) = (/(\w+)\:\:usage\s*\=\s*\"(.*)/)) {  
	while ($Start !~ /\"/) { $Start .= " " . <STDIN> ; }  
	print "\n \\framebox{ \\parbox{14cm}{ "; 
	if ($Start =~ /\"/) { &printtext( $` , $Name ); }
	print " } } \n \\vspace{0.3cm} \n "; } }
print "\\end{document} \n\n ";

sub printtext {
	local($text) = @_[0] ;
	local($name) = @_[1] ;
	$text =~ s/(theta|tau|epsilon|rho|delta)_/\$\\$1\$/g;
	$text =~ s/mean_/\$\\mu\$/g ;
	$text =~ s/mean(\d)_/\$\\mu{_}$1\$/g ;
	$text =~ s/underlineTau_/\$\\underline{\\tau}\$/g ;
	$text =~ s/rho(\d)_/\$\\rho{_}$1\$/g ;	
	$text =~ s/rho(\d)p_/\$\\rho'{_}$1\$/g ;	
	$text =~ s/rho(\d)pp_/\$\\rho''{_}$1\$/g ;	
	$text =~ s/rhoP_/\$\\rho'{_}N\$/g ;	
	$text =~ s/rhoPP_/\$\\rho''{_}N\$/g ;
	$text =~ s/maxCounter_/\$M\$/g;
	$text =~ s/boundary_/\$B\$/g;
	$text =~ s/upValue_/\$UP\$/g;
	$text =~ s/botValue_/\$BOT\$/g;
	$text =~ s/bot_/\$\\{BOT\\}\$/g;
	$text =~ s/up_/\$\\{UP\\}\$/g;
	$text =~ s/index_/\$i\$/g;
	$text =~ s/step_/\$S\$/g;
	$text =~ s/(\W)(\w)_/$1\$$2\$/g ;
	$text =~ s/_/\\_/g ;
	$text =~ s/>/\$>$/g ;	
	$text =~ s/</\$<$/g ;	
	$text =~ s/{\\_}/_/g ;
	if ($name ne "") { $text =~ s/$name/\{\\bf $name\}/g; }
	print $text;
}
