/********************************************
 Contains some basic functions and 
  prototypes that are used in my programs.
    Fabio Cozman
Date: Feb 1 94
*********************************************/

#ifdef GIL___LIBRARY
#include </IUS/vasc_local/include/vision/gimage.h>
typedef IMAGE FG_Image_float;
typedef IMAGE FG_Image;
typedef SUBIMAGE FG_Subimage;
#endif

#ifdef AVS___LIBRARY
#include <avs/field.h>
#define IM_INT 2 /* from gimage.h, for compatibility only (not used) */
typedef AVSfield_float FG_Image_float;
typedef AVSfield_int FG_Image;
typedef struct sub { int rs, re, cs, ce; } FG_Subimage;
#endif

typedef void *Data;

int fg_i_rstart(FG_Image *image);

int fg_i_rend(FG_Image *image);

int fg_i_cstart(FG_Image *image);

int fg_i_cend(FG_Image *image);

FG_Image *fg_i_open(char *name, int flag, int *error);

FG_Image *fg_i_newimat(FG_Subimage bounds, int *error);

void fg_i_copy(FG_Image *image_in, FG_Image *image_out, int value, int *error);

void fg_i_close(FG_Image *image, int *error);

void fg_i_clrimg(FG_Image *image);

void fg_i_iputpixel(FG_Image *image, int x, int y, int value);

void fg_i_fputpixel(FG_Image_float *image, int x, int y, float value);

int fg_i_igetpixel(FG_Image *image, int x, int y);

float fg_i_fgetpixel(FG_Image_float *image, int x, int y);

void fg_i_line(FG_Image *image, float x1, float y1, float x2, float y2,
	       int *value);

void error(char *message, int number);

