/*************************************************************************
*
*  struct.h -- For use with TESTRCP
*
*  Modified:
*     WAA, 06-16-95 -- Changed "fuel" to "battery_voltage" for RATLER.
*
**************************************************************************/

typedef  unsigned char  byte;

typedef struct
{
   int   opcode;  /* Has task-specific meaning */
   union
   {
      byte data[10]; /* Actual individual data bytes */
      char *buffer;  /* Pointer to a buffer containing data */
   } u;

} MESSAGESTRUCT;

typedef struct
{
   long pan;
   long xpos;
   long ypos;
   int  tilt;

   int hi_res_left_throttle;
   int hi_res_right_throttle;

   byte scale_speed;
   byte vehmode;

   byte kill;
   byte parking_brake;

   byte left_throttle;
   byte right_throttle; /* aka THROTTLE1 */

   byte left_gear;
   byte right_gear;     /* aka GEAR1 */

   byte package;
   byte video_power;

   byte logging;

   byte send_triple;
} VEHCMD;

typedef struct
{
   long pan;
   long xpos;
   long ypos;
   long wheel0;
   long wheel1;
   long wheel2;
   long wheel3;

   int  heading;
   int  altimeter;
   int  eng_temp;
   int  turn_rate;
   int  accum_odom;

   byte vehmode;
   byte kill;

   byte video_power;
   byte parking_brake;

   byte abort_code;
   byte left_pitch;
   byte right_pitch;

   byte roll;
   byte speed;

   byte battery_voltage;

   byte odometer;  /* incremental */

   byte package;
   byte scale_speed;

   byte logging;
} VEHSTAT;
