/*************************************************************************
* $include$="\ratler\common\h\pdscan.h"
*
*	!name!
*
* rtlrcp.h
*
*	!paths!
*	files\header
*
***************************************************************************
*!0!
*
*  rtlrcp.h -- Defines for manipulating RATLER RCP blocks.
*
*  Modified:
*     waa, 03-04-94 -- Updated QUERY_CHAR and SELECT_CHAR to use the
*                      defines from rcpdef.h.  Updated SELECT_LENGTH
*                      from 6 to 7 bytes.  Added VEHICLE1_ID, VEHICLE2_ID,
*                      and CDS_ID to support new RCP with vehicle ID's.
*     waa, 03-30-94 -- Moved MIN/MAX CMD and STATUS block definitions
*                      into the enum instead of having separate #defines
*                      to update.
*!end!
**************************************************************************/

#ifndef RTLRCPDOTH
#define RTLRCPDOTH

#define  QUERY_LENGTH   7          /* Number of bytes in RCP query block */
#define  QUERY_CHAR     QUERY_BLOCK  /* RCP command for block request */
#define  SELECT_LENGTH  7          /* Number of bytes in RCP select block */
#define  SELECT_CHAR    SELECT_RV  /* RCP command for vehicle select */
#define  HIGH_BIT       0x80       /* High bit set in RCP data bytes */

/* Vehicle ID's (these are arbitrary) */
#define VEHICLE1_ID    0
#define VEHICLE2_ID    1
#define CDS_ID       101

/* Broadcast ID (not arbitrary) */
#define BROADCAST_ID 127


typedef enum Block_number {
            MIN_CMD_BLOCK = 0,
   /*  0 */ SPEED_SCALE_CMD_BLOCK = MIN_CMD_BLOCK,
   /*  1 */ MODE_CHANGE_CMD_BLOCK,
   /*  2 */ DRIVE_CMD_BLOCK,
   /*  3 */ PAN_TILT_CMD_BLOCK,
   /*  4 */ LIBS_CMD_BLOCK,
   /*  5 */ TRANSMITTER_CMD_BLOCK,
   /*  6 */ POSITION_CMD_BLOCK,
   /*  7 */ LOGGING_CMD_BLOCK,
   /*  8 */ HI_RES_DRIVE_CMD_BLOCK,
   /*  9 */ IMAGE_TRIPLE_CMD_BLOCK,
            MAX_CMD_BLOCK = IMAGE_TRIPLE_CMD_BLOCK,

            MIN_STATUS_BLOCK = 20,
   /* 20 */ MODE_STATUS_BLOCK = MIN_STATUS_BLOCK,
   /* 21 */ DRIVE_STATUS_BLOCK,
   /* 22 */ POSITION_STATUS_BLOCK,
   /* 23 */ MISC_STATUS_BLOCK,
   /* 24 */ LIBS_STATUS_BLOCK,
   /* 25 */ SPEED_SCALE_STATUS_BLOCK,
   /* 26 */ LOGGING_STATUS_BLOCK,
   /* 27 */ KITCHEN_SINK_STATUS_BLOCK,
            MAX_STATUS_BLOCK = KITCHEN_SINK_STATUS_BLOCK
} BLOCK_NUMBER;


/* The QUERY block that is used specifically for keeping the vehicles alive...*/
#define KEEP_ALIVE_BLOCK	MODE_STATUS_BLOCK


/* For determining if a command byte type */
#define is_vehicle_command(n) ((n)>=MIN_CMD_BLOCK && (n)<=MAX_CMD_BLOCK)
#define is_vehicle_status(n)  ((n)>=MIN_STATUS_BLOCK && (n)<=MAX_STATUS_BLOCK)

#endif
