/*
   FILE - RCPTYPE.H

   Frank Wunderlin, Wendy Amai
   Sandia National Laboratories Dept. 9616
   (505) 844-5903

   This file contains the type definitions used by the robotic
   communication protocol.
*/

#ifndef RCPTYPEDOTH
#define RCPTYPEDOTH

#ifndef RCPDEFDOTH
#include "rcpdef.h"
#endif

#ifndef TYPEBYTE
typedef  unsigned char  byte;
#define TYPEBYTE 1
#endif

typedef  unsigned long int  addr_pkt;   /* address where packet data is stored
                                           to or retrieved from */


typedef struct pkt_node
   {
   unsigned int pkt_num;     /* The number of the packet being referenced */
   byte jobnum;              /* The job number to start  */
   struct pkt_node *next;    /* pointer to next packet node */
   } pkt_node;

typedef struct blk_node
{
   unsigned int     blk_num;  /* Ranges from 0 to MAX_BLOCK-1 */
   struct blk_node *next;
} BLK_NODE;

typedef int (*int_fptr)(void);     /* pointer to int function with void
                                      parameter */

typedef struct    /* structure with all the information for one port */
{
   int_fptr  jobs[MAX_JOBS];
   pkt_node *blocks[MAX_BLOCKS];
   addr_pkt *pkt_data[MAX_PACKETS];
   BLK_NODE *block_stream;
} RCP_STRUCT;

#endif
