/*
   FILE - RCPPROTO.H

   Frank Wunderlin, Wendy Amai
   Sandia National Laboratories Dept. 9616
   (505) 844-5903

   This file contains the prototypes for functions used by the robotic
   communication protocol.
*/
#ifndef RCPPROTO_H
#define RCPPROTO_H

#include "rcptype.h"  /* for byte typedef */

int  add_module( int port, int *mod_blks, int *blk_num );
void block_define( int port, int block_num, int num_pkts,
                   int *pkt_id, byte *job_id);
int  build_stream( int port, int block_num, byte *stream, int *count );
void crcupdate( unsigned char data, unsigned short *accum );
int  enter_stream_mode( int port );
int  execute_stream( int port, byte *stream, int *count, byte vehicle_id);
byte extractbits(byte addr, byte where, byte count);
byte getbits( long int, byte, byte, byte );
int  get_block_num( int *blk_num );
unsigned short get_crc( unsigned char *buff, int buff_size );
void insert_crc( unsigned char *BuffPtr, int *NumBytes, int Fixed );
void loadbits(byte **, byte *, byte, long int );
int  partition_block( int port, int block_num, byte *stream );
int rcp_initialize( unsigned int );
int  run_job( int port, byte job_id );
int  set_block_stream( int port, char *blocks);
byte set_cksum( byte *, byte * );
int  set_pkt_addr(int , void *);
int  set_user_job( int port, byte job_id, int (*fptr)() );
int  set_user_pkt_addr ( int port, int pktnum, void *dataptr );
void show_block( int );
long stripbits( byte **, byte *, byte );
int  validate_block( int num_bytes, byte *stream );
int verify_checksum( unsigned char *p, int n );
int build_block( int port, int block_num, byte *stream , int *count,
                 byte dest_id);

#endif