/*
   FILE - RCPBLOCK.H

   Frank Wunderlin, Wendy Amai
   Sandia National Laboratories Dept. 9616
   (505) 844-5903

   This file contains constants that should be used when declaring an
   application defined (verses fixed) communication block, and block
   stream for use in stream mode.  Blocks define the sequence of data
   packets that a robotic vehicle will transmit to and receive from
   a driving station.  A block stream is the stream that is transmitted
   continuously to from a vehicle.

   Two classes of blocks exist, fixed and application specific.  Fixed blocks
   are those blocks that are common to all robotic applications, fixed blocks
   are identified by their block number ( 64 <= fixed block number <= 127 ).

   The constants defined below act as flags when application specific blocks
   are defined.  The flags in combination with data packets that are defined
   in PACKETS.H are used to describe the application specific blocks to the
   communication module.  It is up to the communication module to assign
   block numbers to these application specific streams of data.

   One method used to set these blocks up is to declare a variable length
   array as shown in the example file MODULE.H.  Each module may define its
   own data blocks thereby encapsulating logically related functions; i.e.,
   robotic manipulator, path planning, position location, etc.
*/

#ifndef RCPBLOCKDOTH
#define  RCPBLOCKDOTH

#define OUTGOING 0    /* flag used to mark a block that will be transmitted */
#define INCOMING 1    /* flag used to mark a block that will be recieved */

#define SET_END     (-1)   /*   This flags the end of a logically related
                               set of packets, this set of packets may
                               be linked to a application defined job, the
                               flag that follows determines what action to
                               take.  One of the flags below MUST ( FUNC_xx )
                               must follow this flag.
                          */



#define BLOCK_END  (-2)   /*  This flags the end of a stream of data; i.e.,
                              a block of data that will be tramistted as
                              a single stream.
                          */


#define MODULE_END (-3)   /* This flag is used by the communication module
                             to signal the end of the block definitions
                             used by a module.  It implicitly serves as an
                             end of array marker.
                          */

#define STREAM_END (-1)   /* In a stream definition, marks the end of
                             the stream data */

/*
   The following flags are used to map application defined jobs to
   logically related packets of data (sets).  These jobs may be merely
   function calls in the case of a single tasking OS or a function that
   wakes, spawns, or signals a task in a multi-tasking OS (i.e., these
   functions may be application and/or OS dependent actions to execute).
*/

typedef enum {
  FUNC_NULL,
  FUNC_1,
  FUNC_2,
  FUNC_3,
  FUNC_4,
  FUNC_5,
  FUNC_6,
  FUNC_7,
  FUNC_8,
  FUNC_9,
  FUNC_10,
  FUNC_11,
  FUNC_12,
  FUNC_13,
  FUNC_14,
  FUNC_15,
  FUNC_16,
  FUNC_17,
  FUNC_18,
  FUNC_19,
  FUNC_20,
  FUNC_21,
  FUNC_22,
  FUNC_23,
  FUNC_24,
  FUNC_25,
  FUNC_26,
  FUNC_27,
  FUNC_28,
  FUNC_29,
  FUNC_30,
  FUNC_31,
  FUNC_32
} RCP_FuncIndex;

#endif
