/*------------------------------------------------------------------------
|       RTD_LCD.C   : Liquid Crystal Display Handling Routines 1.1
|       AUTHOR      : original souce code (c) RTD Scandinavia Oy
|		MODIFIED BY	: Real Time Devices, USA
|       DATE        : 1992, 1993, 1994
|
|       For use with LCD character displays that use the Hitachi HD44780
|       display controller.  Works with 1 or 2 line displays.
|
| Note: Ensure the parallel port is a bidirectional port
|-------------------------------------------------------------------------*/
#include <time.h>

/*---------------------------------------------------------------
| Function:     millisecond_delay( clock_t wait )
| Input:        wait - time in milliseconds
| Returns:      Nothing
| Purpose:      Pauses for a specified number of milliseconds.
|----------------------------------------------------------------*/
void millisecond_delay( clock_t wait );


/*---------------------------------------------------------------
| Function:     int LCD_Read_Status(void)
| Input:        Nothing
| Returns:      Status byte as integer from LCD
|               Bit 7 is busy flag
|               bits 6-0 are address counter contents
| Purpose:      Sends an instruction byte to the LCD by shaking
|               the LPT port control lines
|----------------------------------------------------------------*/
int LCD_Read_Status(void);


/*---------------------------------------------------------------
| Function:     LCD_Send_Instruction(unsigned char instr, char wait)
| Input:        unsigned char instruction
|               char wait, 0 = without busy wait, 1 = with busy wait
| Returns:      Nothing
| Purpose:      Sends an instruction byte to the LCD by shaking
|               the LPT port control lines
|----------------------------------------------------------------*/
void LCD_Send_Instruction(unsigned char instr, char wait);


/*---------------------------------------------------------------
| Function:     void LCD_Move_Cursor(char row, char col)
| Input:        char row, col
| Returns:      Nothing
| Purpose:      Places the LCD cursor at row & col
|----------------------------------------------------------------*/
void LCD_Move_Cursor(char row, char col);


/*---------------------------------------------------------------
| Function:     void LCD_Char_Out(unsigned char data)
| Input:        unsigned char mki
| Returns:      Nothing
| Purpose:      Writes one character at current position
|----------------------------------------------------------------*/
void LCD_Char_Out(unsigned char data);


/*---------------------------------------------------------------
| Function:     LCD_Text_Out(char *), PUBLIC
| Input:        A pointer to a null terminated character string
| Returns:      Nothing
| Purpose:      Prints a string starting from the current cursor
|               position
|----------------------------------------------------------------*/
void LCD_Text_Out(char *s);


/*---------------------------------------------------------------
| Function:     LCD_Clear()
| Input:        Nothing
| Returns:      Nothing
| Purpose:      Clears the entire LCD display
|----------------------------------------------------------------*/
void LCD_Clear(void);


/*---------------------------------------------------------------
| Function:     void LCD_Setup(char rows, char columns, int base_address)
| Input:        rows - # of rows on display (1 - 4)
|               columns - # of columns on display
|               base address - base address of parallel port
| Returns:      Nothing
| Purpose:      Initializes the LCD operating modes
|
|----------------------------------------------------------------*/
void LCD_Setup(char rows, char columns, int base_address);

