/*
*  RCPVALUE.H -- Symbolic values for often-used RCP pkts
*
*  Created: WAA, 04-20-94
*  Modified:
*    WAA, 08-02-94 -- Changed to use actual packet names, e.g., STR_SLAVE,
*                     to be more easily equated with packets.  Put in
*                     alphabetical order for easy lookup.  Added mast
*                     values.
*    WAA, 08-11-94 -- Added package defines.
*    WAA, 09-09-94 -- Added FLIR defines.
*    WAA, 09-12-94 -- Added camera defines.
*    WAA, 09-13-94 -- Added video transmitter defines.
*    WAA, 09-14-94 -- Put these latest defines in the form RCP_varname_value.
*    WAA, 09-26-94 -- Added GPS reference packet stuff (again).
*    WAA, 09-28-94 -- Added GPS delta defines for lat/long and elevation.
*    WAA, 02-17-95 -- Added PAN and TILT defines for rate mode, added
*                     duplicate position mode defines for PAN and TILT in
*                     RCP_varname_value form.
*    WAA, 03-14-95 -- Merged existing copy with copy in SARGE\WENDY\READY8,
*                     which included the GPS stuff.
*    WAA, 06-16-95 -- Added RCP_PAN_STOP and RCP_TILT_STOP.  Need to check
*                     values of the RCP_PAN_LEFT, PAN_RIGHT, TILT_UP,
*                     TILT_DOWN packets which do not contain rate info
*                     (rate is zero, therefore no movement).
*/

#ifndef RCPVALUEDOTH
#define RCPVALUEDOTH


/* ON/OFF-valued pkts */
#define RCP_ON      1
#define RCP_OFF     0


/* BRAKE, BRAKE1, THROTTLE, THROTTLE1 pkts */
#define RCP_NO_BRAKE        0
#define RCP_FULL_BRAKE    127
#define RCP_NO_THROTTLE     0
#define RCP_FULL_THROTTLE 127

/* CAMERA0, CAMERA1 pkts */
#define RCP_CAMERA_ID_MASK    0x0380
#define RCP_CAMERA_PWR_MASK   0x0040
#define RCP_CAMERA_IRIS_MASK  0x0030
#define RCP_CAMERA_FOCUS_MASK 0x000c
#define RCP_CAMERA_ZOOM_MASK  0x0003
/* Camera ID.  All these fields match the masks above */
#define RCP_CAMERA_ID_0       0x0000
#define RCP_CAMERA_ID_1       0x0080
#define RCP_CAMERA_ID_2       0x0100
#define RCP_CAMERA_ID_3       0x0180
#define RCP_CAMERA_ID_4       0x0200
#define RCP_CAMERA_ID_5       0x0280
#define RCP_CAMERA_ID_6       0x0300
#define RCP_CAMERA_ID_7       0x0380
/* Camera power */
#define RCP_CAMERA_ON         0x0040
#define RCP_CAMERA_OFF        0x0000
/* Camera iris */
#define RCP_CAMERA_IRIS_UNDF  0x0030
#define RCP_CAMERA_IRIS_OPEN  0x0020
#define RCP_CAMERA_IRIS_CLOSE 0x0010
#define RCP_CAMERA_IRIS_STOP  0x0000
/* Camera focus */
#define RCP_CAMERA_FOCUS_UNDF 0x000c
#define RCP_CAMERA_FOCUS_NEAR 0x0008
#define RCP_CAMERA_FOCUS_FAR  0x0004
#define RCP_CAMERA_FOCUS_STOP 0x0000
/* Camera zoom */
#define RCP_CAMERA_ZOOM_UNDF  0x0003
#define RCP_CAMERA_ZOOM_OUT   0x0002
#define RCP_CAMERA_ZOOM_IN    0x0001
#define RCP_CAMERA_ZOOM_STOP  0x0000

/* GEAR, GEAR1 pkts */
#define RCP_FORWARD 3
#define RCP_NEUTRAL 2
#define RCP_REVERSE 1

/* FLIR pkt */
#define RCP_FLIR_POWER_MASK    0x80
#define RCP_FLIR_CONTRAST_MASK 0x60 /* aka GAIN */
#define RCP_FLIR_ALIGN_MASK    0x18
#define RCP_FLIR_BRIGHT_MASK   0x06
#define RCP_FLIR_POLARITY_MASK 0x01
/* FLIR power.  All these fields match the masks above */
#define RCP_FLIR_POWER_ON      0x80
#define RCP_FLIR_POWER_OFF     0x00
/* FLIR contrast */
#define RCP_FLIR_CONTRAST_UNDF 0x60
#define RCP_FLIR_CONTRAST_HIGH 0x40
#define RCP_FLIR_CONTRAST_MED  0x20
#define RCP_FLIR_CONTRAST_LOW  0x00
/* FLIR alignment */
#define RCP_FLIR_ALIGN_UNDF    0x18
#define RCP_FLIR_ALIGN_INCR    0x10
#define RCP_FLIR_ALIGN_DECR    0x08
#define RCP_FLIR_ALIGN_SAME    0x00
/* FLIR brightness */
#define RCP_FLIR_BRIGHT_UNDF   0x06
#define RCP_FLIR_BRIGHT_INCR   0x04
#define RCP_FLIR_BRIGHT_DECR   0x02
#define RCP_FLIR_BRIGHT_SAME   0x00
/* FLIR polarity */
#define RCP_FLIR_WHITE_HOT     0x01 /* For polarity */
#define RCP_FLIR_BLACK_HOT     0x00 /* For polarity */

/* FUEL packet */
#define RCP_FUEL_EMPTY            0
#define RCP_FUEL_FULL            15

/* GPS_LAT, GPS_LONG pkts, */
#define RCP_GPS_REF_DEGREES    * 64 /* To shift into position */
#define RCP_GPS_REF_MINUTES         /* NOP, as minute bits already LSBits */
#define RCP_GPS_DEL_OFFSET      150 /* sec, 2.5' for delta offset */
#define RCP_GPS_DEL_ZERO    0x3d090 /* Zero delta */
#define RCP_GPS_DEL_MAX     0x7ffff /* Maximum RCP delta value */
/* GPS_LAT only */
#define RCP_GPS_REF_NORTH         0 /* Add to get North latitude pkt */
#define RCP_GPS_REF_SOUTH    0x2000 /* Add to get South latitude pkt */
/* GPS_LONG only */
#define RCP_GPS_REF_WEST          0 /* Add to get West longitude pkt */
#define RCP_GPS_REF_EAST     0x4000 /* Add to get East longitude pkt */
/* GPS_ELEV only */
#define RCP_GPS_DEL_ELEV_POS      0 /* Add to denote elevation above MSL */
#define RCP_GPS_DEL_ELEV_NEG 0x2000 /* Add to denote elevation below MSL */

/* HEADING0, HEADING1 pkts */
#define RCP_HEADING_MAX  1022

/* KILL_STATE pkt */
#define RCP_NO_KILL 0
#define RCP_KILL    1

/* MAST_CNTL pkt */
#define RCP_MAST_UP   1
#define RCP_MAST_DOWN 2
#define RCP_MAST_STOP 0

/* PACKAGE pkts */
#define RCP_PKG_OFF  0x0  /* bit pattern 0000 */
#define RCP_PKG_ON   0x3  /* bit pattern 0011 */
#define RCP_PKT_STBY 0x6  /* bit pattern 0110 */

/* PAN0, PAN1, TILT0, TILT1 pkts */
#define RCP_PAN_CENTER  ((2048L << 5) | 0x1f) /* Centers pan at max rate */
#define RCP_PAN_STOP    0L
#define RCP_PAN_LEFT  0L           /* Rate mode pan left */
#define RCP_PAN_RIGHT (4095L << 5) /* Rate mode pan right */
#define RCP_TILT_CENTER ((1024 << 5) | 0x1f)  /* Centers tilt at max rate */
#define RCP_TILT_STOP 0L
#define RCP_TILT_UP   (2047L << 5) /* Rate mode tilt up */
#define RCP_TILT_DOWN 0L           /* Rate mode tilt down */
  /* These two should be eliminated, not of form RCP_varname_value */
#define RCP_CENTER_PAN  ((2048L << 5) | 0x1f) /* centers pan at max rate */
#define RCP_CENTER_TILT ((1024 << 5) | 0x1f)  /* centers tilt at max rate */

/* PITCH, ROLL, INCLINE2 pkts */
#define RCP_LEVEL_PITCH  64
#define RCP_LEVEL_ROLL   64

/* STEERING pkt */
#define RCP_CENTER_STEERING  64

/* STR_SLAVE pkt */
#define RCP_SLAVED    1
#define RCP_RATE_CTRL 0

/* Temperature packets, ENGINE, COMPUTER, AMBIENT */
#define RCP_TEMP_ZERO_C  256 /* Zero degrees Celsius */

/* VEH_MODE pkt, modified 05-23-94 to conform to rcppkts.h and RCP doc */
#define RCP_SAFE    0
#define RCP_SURV    1
#define RCP_PAUSE   2
#define RCP_TELEOP  3
#define RCP_AUTON   4
#define RCP_QUIET   5

/* PKT_CMD_VIDEO0_XMITER, PKT_STAT_VIDEO0_XMITER,
   PKT_CMD_VIDEO1_XMITER, PKT_STAT_VIDEO1_XMITER pkts */
#define RCP_VID_XMTR_OFF   0
#define RCP_VID_PWR_LOW    1
#define RCP_VID_PWR_MED    2
#define RCP_VID_PWR_HIGH   3

#endif

