/**********************************************************************/
#if 0
   FILE - RCPPKTS.H

   Frank Wunderlin, Wendy Amai
   Sandia National Laboratories Dept. 9616
   (505) 844-5903

   This file contains the packet numbers and their size (in bits)
   for each data packet defined by the robotic communication protocol.
   Bit setttings may be defined individually (in which case they are
   designated as either TRUE/ON or FALSE/OFF).  If the packet is
   designated as a binary number, the leftmost bit is defined as the
   most significant number given a range from 0 to pow( 2,n ) - 1).
   Packets may require an offset from the explicit values to derive
   the correct value being transmitted.

	THE FOLLOWING CONVENTIONS MUST BE OBSERVED IN THIS FILE!!!

	after each packet definition include a comment with an opening space,
	3 pound signs,  one space, and the number of bits in that packet.
	This information is used to automatically generate the file RCPBITS.H
	with the program getbits.exe to be run in the rcp directory.

	e.g.

	#define PKT_CMD_STEERING 0
	/* ### 7 bits */

	The packets will be named PKT_CMD_XXX for information flowing from the
	CDS to the robot and PKT_STAT_XXX for information flowing from the robot
	back to the CDS

Modified:
   waa  04-02-91 -- Changed number of bits in PKT_CMD/STAT_XFER_CASE to 3.
   waa  01-18-93 -- Added PKT_CMD_CLEAR_ERR, copied from 10-21-91 version
		    into 09-03-91 version.  The packets now comply with
		    the original RCP document again.
		    Added the following totally new packets to support
		    the RATLER project:  P106-P120.
   fkw  12-10-93 -- Added pkts 121 - 137 for RATLER.
                    Redefined pkts 24-35, 70-73, 76-77, 95-97, 120.
   waa  02-11-94 -- Added pkts 138-146 for SARGE.
   waa  02-28-94 -- Added pkts 147-149 for SARGE.
   waa  03-03-94 -- Added pkts 150-153 for SARGE.
   waa  03-30-94 -- Added pkts 154-161 for RATLER.
   waa  04-20-94 -- Added pkt 162 for RATLER.
   waa  08-10-94 -- Changed PKT_xxx_GPS_LAT from 15 to 14 bits.  Updated
                    definitions for P121-P124 and P127-P130.

#endif
/****************************************************************************/

#ifndef RCPPKTSDOTH
#define RCPPKTSDOTH

#define PKT_CMD_STEERING 0
/* ### 7 bits */          /* 0 = full left, 64 = center, 127 = full right */

#define PKT_STAT_STEERING 1
/* ### 7 bits */     /* 0 = full left, 64 = center, 127 = full right */

#define PKT_CMD_THROTTLE 2
/* ### 7 bits */    /* 0 = no throttle, 127 = full throttle */

#define PKT_STAT_THROTTLE 3
/* ### 7 bits */    /* 0 = no throttle, 127 = full throttle */

#define PKT_CMD_BRAKE 4
/* ### 7 bits */        /* 0 = no brake, 127 = full brake */

#define PKT_STAT_BRAKE 5
/* ### 7 bits */        /* 0 = no brake, 127 = full brake */

#define PKT_STAT_RPM 6
/* ### 7 bits */          /* rpm/100; i.e., 0 - 12700 rpms */

#define PKT_STAT_OIL_PRESS 7
/* ### 7 bits */    /* in lbs/sq inch 0 - 127 */

#define PKT_CMD_GEAR 8
/* ### 3 bits */         /* 0 = park, 1 = rev, 2 = neu, 3 = 1st, 4 = 2nd */
			 /* 5 = 3rd,  6 = 4th, 7 = no gear */

#define PKT_STAT_GEAR 9
/* ### 3 bits */         /* 0 = park, 1 = rev, 2 = neu, 3 = 1st, 4 = 2nd */
			 /* 5 = 3rd,  6 = 4th, 7 = no gear */

#define PKT_CMD_XFER_CASE 10
/* ### 3 bits */    /* 0 = 2wd, 1 = 4wd hi, 2 = neu, 3 = 4wd lo, 4 = no gear */

#define PKT_STAT_XFER_CASE 11
/* ### 3 bits */    /* 0 = 2wd, 1 = 4wd hi, 2 = neu, 3 = 4wd lo, 4 = no gear */

#define PKT_CMD_IGNITION 12
/* ### 1 bit */     /* 1 = ON, 0 = OFF */

#define PKT_STAT_IGNITION 13
/* ### 1 bit */     /* 1 = ON, 0 = OFF */

#define PKT_CMD_STARTER 14
/* ### 1 bit */      /* 1 = ON, 0 = OFF */

#define PKT_STAT_STARTER 15
/* ### 1 bit */      /* 1 = ON, 0 = OFF */

#define PKT_CMD_CHOKE 16
/* ### 1 bit */        /* 1 = ON, 0 = OFF */

#define PKT_STAT_CHOKE 17
/* ### 1 bit */        /* 1 = ON, 0 = OFF */

#define PKT_CMD_LIGHT0 18
/* ### 1 bit */       /*  light state 1 = ON, 0 = OFF */

#define PKT_STAT_LIGHT0 19
/* ### 1 bit */       /*  light state 1 = ON, 0 = OFF */

#define PKT_CMD_LIGHT1 20
/* ### 1 bit */        /*  light state 1 = ON, 0 = OFF */

#define PKT_STAT_LIGHT1 21
/* ### 1 bit */        /*  light state 1 = ON, 0 = OFF */


#define PKT_STAT_PITCH 22
/* ### 7 bits */
         /* 0 = full pitch forward, nose down or -64 degrees */
			/* 64 = level or 0 degrees                          */
         /* 127 = full pitch back, nose up or +63 degrees */

#define PKT_STAT_ROLL 23
/* ### 7 bits */    /* 0 = full roll right, left side up - right down */
		    /* 64 = level, 127 = full roll left, right up */

#define PKT_CMD_PAN0 24
/* ### 17 bits */
           /* bits 16 - 5 is a 12 bit value representing 0 - 360    */
           /* degrees increasing clockwise - Position value =       */
           /* ((RCP value-1) * 360/4094).  Values of 0 and 4095 are */
           /* special cases reserved for designating rate mode,     */
           /* 0 = rate control rotating counterclockwise            */
           /* 4095 = rate control rotating clockwise.               */

#define PKT_STAT_PAN0 25
/* ### 17 bits */
           /* bits 16 - 5 is a 12 bit value representing 0 - 360    */
           /* degrees increasing clockwise - Position value =       */
           /* ((RCP value-1) * 360/4094).  Values of 0 and 4095 are */
           /* special cases reserved for designating rate mode,     */
           /* 0 = rate control rotating counterclockwise            */
           /* 4095 = rate control rotating clockwise.               */

#define PKT_CMD_PAN1 26
/* ### 17 bits */
           /* bits 16 - 5 is a 12 bit value representing 0 - 360    */
           /* degrees increasing clockwise - Position value =       */
           /* ((RCP value-1) * 360/4094).  Values of 0 and 4095 are */
           /* special cases reserved for designating rate mode,     */
           /* 0 = rate control rotating counterclockwise            */
           /* 4095 = rate control rotating clockwise.               */

#define PKT_STAT_PAN1 27
/* ### 17 bits */
           /* bits 16 - 5 is a 12 bit value representing 0 - 360    */
           /* degrees increasing clockwise - Position value =       */
           /* ((RCP value-1) * 360/4094).  Values of 0 and 4095 are */
           /* special cases reserved for designating rate mode,     */
           /* 0 = rate control rotating counterclockwise            */
           /* 4095 = rate control rotating clockwise.               */

#define PKT_CMD_TILT0 28
/* ### 16 bits */
      /* bits 15 - 5 is an 11 bit value representing tilt, -90 - +89.9   */
      /* degrees.  Tilt position value = ((RCP value-1024) * 180/2046).  */
      /* Values of 0 and 2047 are special cases reserved for designating */
      /* rate mode, 0 = rate control rotating down (towards -90 degrees  */
      /* and 2047 = rate control rotating up (towards +89.9 degrees.     */

#define PKT_STAT_TILT0 29
/* ### 16 bits */
      /* bits 15 - 5 is an 11 bit value representing tilt, -90 - +89.9   */
      /* degrees.  Tilt position value = ((RCP value-1024) * 180/2046).  */
      /* Values of 0 and 2047 are special cases reserved for designating */
      /* rate mode, 0 = rate control rotating down (towards -90 degrees  */
      /* and 2047 = rate control rotating up (towards +89.9 degrees.     */

#define PKT_CMD_TILT1 30
/* ### 16 bits */
      /* bits 15 - 5 is an 11 bit value representing tilt, -90 - +89.9   */
      /* degrees.  Tilt position value = ((RCP value-1024) * 180/2046).  */
      /* Values of 0 and 2047 are special cases reserved for designating */
      /* rate mode, 0 = rate control rotating down (towards -90 degrees  */
      /* and 2047 = rate control rotating up (towards +89.9 degrees.     */

#define PKT_STAT_TILT1 31
/* ### 16 bits */
      /* bits 15 - 5 is an 11 bit value representing tilt, -90 - +89.9   */
      /* degrees.  Tilt position value = ((RCP value-1024) * 180/2046).  */
      /* Values of 0 and 2047 are special cases reserved for designating */
      /* rate mode, 0 = rate control rotating down (towards -90 degrees  */
      /* and 2047 = rate control rotating up (towards +89.9 degrees.     */

#define PKT_CMD_CAMERA0_CNTL 32
/* ### 10 bits */
           /* bits 9 - 7 = camera ID, value 0 - 7            */
           /* bit 6 = camera power; 0 = off, 1 = on          */
           /* bit 5 = manual iris open; 0 = false, 1 = true  */
           /* bit 4 = manual iris close; 0 = false, 1 = true */
           /* bit 3 = focus out; 0 = false, 1 = true         */
           /* bit 2 = focus in; 0 = false, 1 = true          */
		     /* bit 1 = zoom out; 0 = false, 1 = true          */
           /* bit 0 = zoom in; 0 = false, 1 = TRUE           */

#define PKT_STAT_CAMERA0_CNTL 33
/* ### 10 bits */
           /* bits 9 - 7 = camera ID, value 0 - 7            */
           /* bit 6 = camera power; 0 = off, 1 = on          */
           /* bit 5 = manual iris open; 0 = false, 1 = true  */
           /* bit 4 = manual iris close; 0 = false, 1 = true */
           /* bit 3 = focus out; 0 = false, 1 = true         */
           /* bit 2 = focus in; 0 = false, 1 = true          */
		     /* bit 1 = zoom out; 0 = false, 1 = true          */

#define PKT_CMD_CAMERA1_CNTL 34
/* ### 10 bits */
           /* bits 9 - 7 = camera ID, value 0 - 7            */
           /* bit 6 = camera power; 0 = off, 1 = on          */
           /* bit 5 = manual iris open; 0 = false, 1 = true  */
           /* bit 4 = manual iris close; 0 = false, 1 = true */
           /* bit 3 = focus out; 0 = false, 1 = true         */
           /* bit 2 = focus in; 0 = false, 1 = true          */
		     /* bit 1 = zoom out; 0 = false, 1 = true          */

#define PKT_STAT_CAMERA1_CNTL 35
/* ### 10 bits */
           /* bits 9 - 7 = camera ID, value 0 - 7            */
           /* bit 6 = camera power; 0 = off, 1 = on          */
           /* bit 5 = manual iris open; 0 = false, 1 = true  */
           /* bit 4 = manual iris close; 0 = false, 1 = true */
           /* bit 3 = focus out; 0 = false, 1 = true         */
           /* bit 2 = focus in; 0 = false, 1 = true          */
		     /* bit 1 = zoom out; 0 = false, 1 = true          */

#define PKT_CMD_VIDEO0_XMITER 36
/* ### 2 bits */   /* power level, 0 = turned off, 3 = hi power */

#define PKT_STAT_VIDEO0_XMITER 37
/* ### 2 bits */   /* power level, 0 = turned off, 3 = hi power */

#define PKT_CMD_VIDEO1_XMITER 38
/* ### 2 bits */   /* power level, 0 = turned off, 3 = hi power */

#define PKT_STAT_VIDEO1_XMITER 39
/* ### 2 bits */   /* power level, 0 = turned off, 3 = hi power */

#define PKT_CMD_MAST_CNTL 40
/* ### 2 bits */    /* bit 1 = down, bit 0 = up; 1 = TRUE */

#define PKT_STAT_MAST_CNTL 41
/* ### 2 bits */    /* bit 1 = down, bit 0 = up; 1 = TRUE */

#define PKT_CMD_MAST_HEIGHT 42
/* ### 7 bits */  /* 0 - 127, 2.5 inch per increment */

#define PKT_STAT_MAST_HEIGHT 43
/* ### 7 bits */  /* 0 - 127, 2.5 inch per increment */

#define PKT_CMD_HEADING0 44
/* ### 10 bits */         /* degrees with .352 degree/count */
			  /* 1022 = 359.744 deg */

#define PKT_STAT_HEADING0 45
/* ### 10 bits */         /* degrees with .352 degree/count */
			  /* 1022 = 359.744 deg */

#define PKT_CMD_HEADING1 46
/* ### 10 bits */         /* degrees with .352 degree/count */
			  /* 1022 = 359.744 deg */

#define PKT_STAT_HEADING1 47
/* ### 10 bits */         /* degrees with .352 degree/count */
			  /* 1022 = 359.744 deg */

#define PKT_STAT_ABS_OD 48
/* ### 16 bits */        /* ticks of the odometer in absoulte distance */
			 /* traveled, the unit of each tick is defined */
			 /* by the OD_SCALE packet, default is 0.1 meter */


#define PKT_STAT_INC_OD 49
/* ### 7 bits */        /* ticks of the odometer in incremental distance */
			/* traveled, the unit of each tick is defined */
			/* by the OD_SCALE packet, default is 0.1 meter */


#define PKT_CMD_OD_SCALE 50
/* ### 11 bits */      /* how to interpret each tick of the ABSOLUTE */
		       /* and INCREMENTAL ODOMETER packets.  Each tick */
		       /* of the scale is 1 millimeter with 0 = 1 and */
		       /* 2047 = 2048 millimeter. */

#define PKT_STAT_OD_SCALE 51
/* ### 11 bits */      /* how to interpret each tick of the ABSOLUTE */
		       /* and INCREMENTAL ODOMETER packets.  Each tick */
		       /* of the scale is 1 millimeter with 0 = 1 and */
		       /* 2047 = 2048 millimeter. */

#define PKT_CMD_SPEED 52
/* ### 8 bits */        /* speed in meters/sec as defined by scale */
			/* given in SPEED SCALE packet, if no scale */
			/* given, defaults to 0.1 meter/sec  */

#define PKT_STAT_SPEED 53
/* ### 8 bits */        /* speed in meters/sec as defined by scale */
			/* given in SPEED SCALE packet, if no scale */
			/* given, defaults to 0.1 meter/sec  */

#define PKT_CMD_SCALE_SPEED 54
/* ### 5 bits */          /* how to interpret the SPEED packet in 0.01 */
			  /* meter/sec resolution, 0 = each tick of */
			  /* packet = 0.01 meter/sec, 31 = 0.32 meter/sec */

#define PKT_STAT_SCALE_SPEED 55
/* ### 5 bits */          /* how to interpret the SPEED packet in 0.01 */
			  /* meter/sec resolution, 0 = each tick of */
			  /* packet = 0.01 meter/sec, 31 = 0.32 meter/sec */

#define PKT_STAT_VOLTAGE_BATTERY 56
/* ### 8 bits */       /* 0 = 0v, 255 = 31.875v, 0.125v/state */

#define PKT_STAT_CURRENT_BATTERY 57
/* ### 12 */           /* 0 = -128 amps, 2048 = 0, 4095 = 127.94 amps */

#define PKT_STAT_FUEL 58
/* ### 4 bits */         /* 0 = empty, 15 = full */

#define PKT_STAT_COMPUTER_TEMP 59
/* ### 9 bits */        /* 0 = -256 C, 256 = 0 C, 511 = 255 degrees C. */

#define PKT_STAT_ENGINE_TEMP 60
/* ### 9 bits */        /* 0 = -256 C, 256 = 0 C, 511 = 255 degrees C. */

#define PKT_STAT_AMBIENT_TEMP 61
/* ### 9 bits */        /* 0 = -256 C, 256 = 0 C, 511 = 255 degrees C. */

#define PKT_STAT_WIND_SPEED 62
/* ### 7 bits */        /* 0 - 127 in kph */

#define PKT_STAT_PRECIP 63
/* ### 1 bit */         /* precipitation detected, 1 = TRUE, 0 = FALSE */

#define PKT_CMD_DATA0_XMITER 64
/* ### 2 bits */     /* bits 1 and 0 = power levels, 0 = turned off */

#define PKT_STAT_DATA0_XMITER 65
/* ### 2 bits */     /* bits 1 and 0 = power levels, 0 = turned off */

#define PKT_CMD_DATA1_XMITER 66
/* ### 2 bits */     /* bits 1 and 0 = power levels, 0 = turned off */

#define PKT_STAT_DATA1_XMITER 67
/* ### 2 bits */     /* bits 1 and 0 = power levels, 0 = turned off */

#define PKT_STAT_ALTIMETER 68
/* ### 12 bits */        /* elevation 0 = -100m, 100 = 0m, 4095 = 3995m */
			 /* one meter resolution */

#define PKT_STAT_TURN_RATE 69
/* ### 10 bits */  /* TBD */

#define PKT_CMD_XPOS 70
/* ### 19 bits */
      /* x coordinate 0.1 meter resolution, the MSB is a sign bit      */
      /* with 1 = negative x and 0 = positive x.  Range of the         */
      /* remaining 18 bits is 0 to 262,143 i.e., plus or minus         */
      /* 26.2143 kilometers.  Reference point is application defined.  */

#define PKT_STAT_XPOS 71
/* ### 19 bits */
      /* x coordinate 0.1 meter resolution, the MSB is a sign bit      */
      /* with 1 = negative x and 0 = positive x.  Range of the         */
      /* remaining 18 bits is 0 to 262,143 i.e., plus or minus         */
      /* 26.2143 kilometers.  Reference point is application defined.  */

#define PKT_CMD_YPOS 72
/* ### 19 bits */
      /* y coordinate 0.1 meter resolution, the MSB is a sign bit      */
      /* with 1 = negative y and 0 = positive y.  Range of the         */
      /* remaining 18 bits is 0 to 262,143 i.e., plus or minus         */
      /* 26.2143 kilometers.  Reference point is application defined.  */

#define PKT_STAT_YPOS 73
/* ### 19 bits */        /* y coordinate 0.1 meter resolution */

#define PKT_CMD_UTM 74
/* ### 10 bits */         /* to be determined */

#define PKT_STAT_UTM 75
/* ### 10 bits */         /* to be determined */

#define PKT_STAT_1TBD 76
/* ### 10 bits */         /* to be determined */

#define PKT_STAT_2TBD 77
/* ### 10 bits */         /* to be determined */

#define PKT_CMD_KILL_STATE  78
/* ### 1 bit */           /* if set, kill vehicle, else keep alive */

#define PKT_STAT_KILL_STATE  79
/* ### 1 bit */           /* if set, kill vehicle, else keep alive */

#define PKT_STAT_SOLAR 80   /* solar radiation level (light level) */
/* ### 6 bits */            /* KW/m^2 */

#define PKT_STAT_DIGITAL0_SENSOR  81
/* ### 1 bit */             /* bit is set if sensor is in alarm */

#define PKT_STAT_DIGITAL1_SENSOR  82
/* ### 1 bit */             /* bit is set if sensor is in alarm */

#define PKT_STAT_DIGITAL2_SENSOR  83
/* ### 1 bit */             /* bit is set if sensor is in alarm */

#define PKT_STAT_DIGITAL3_SENSOR  84
/* ### 1 bit */             /* bit is set if sensor is in alarm */

#define PKT_STAT_ANALOG0_SENSOR   85
/* ### 12 bits */           /* analog level */

#define PKT_STAT_ANALOG1_SENSOR   86
/* ### 12 bits */           /* analog level */

#define PKT_STAT_ANALOG2_SENSOR   87
/* ### 12 bits */           /* analog level */

#define PKT_STAT_ANALOG3_SENSOR   88
/* ### 12 bits */           /* analog level */

#define PKT_CMD_STR_SLAVE  89
/* ### 1 bit */            /* if set, driving camera is steering slaved */

#define PKT_STAT_STR_SLAVE  90
/* ### 1 bit */            /* if set, driving camera is steering slaved */

#define PKT_CMD_PARKING_BRAKE 91
/* ### 1 bit */            /* If set, then parking brake is ON */

#define PKT_STAT_PARKING_BRAKE 92
/* ### 1 bit */            /* If set, then parking brake is ON */

#define PKT_STAT_WATER_IN_FUEL 93
/* ### 1 bit */              /* If set, then there is water in fuel */

#define PKT_STAT_WAIT_TO_START 94
/* ### 1 bit */              /* If set, waiting for warm-up before start */

#define PKT_STAT_ERROR_CODE 95
/* ### 7 bits */             /* A code reflecting error */

#define PKT_CMD_VEH_MODE 96
/* ### 3 bits */
    /* 0 = Safe mode                                               */
    /* 1 = Surveilance mode                                        */
    /* 2 = Pause mode, used for mode switching                     */
    /* 3 = Teleoperation mode                                      */
    /* 4 = Autonomous mode                                         */
    /* 5 = Quiet mode, low power consumption, listen for wake up.  */
    /* 6 = Undefined                                               */
    /* 7 = Undefined                                               */

#define PKT_STAT_VEH_MODE 97
/* ### 3 bits */
    /* 0 = Safe mode                                               */
    /* 1 = Surveilance mode                                        */
    /* 2 = Pause mode, used for mode switching                     */
    /* 3 = Teleoperation mode                                      */
    /* 4 = Autonomous mode                                         */
    /* 5 = Quiet mode, low power consumption, listen for wake up.  */
    /* 6 = Undefined                                               */
    /* 7 = Undefined                                               */

#define PKT_CMD_SAFE_MODE 98
/* ### 2 bits */
      /* 0-recover, 1-stop, 2-safe, 3-abort (safe initiated by vehicle) */

#define PKT_STAT_SAFE_MODE 99
/* ### 2 bits */
      /* 0-recover, 1-stop, 2-safe, 3-abort (safe initiated by vehicle) */

#define PKT_CMD_OBS_DET 100
/* ### 1 bit */ /* 0-obstacle detection off, 1-obstacle detection on */

#define PKT_STAT_OBS_DET 101
/* ### 1 bit */ /* 0-obstacle detection off, 1-obstacle detection on */

#define PKT_STAT_POS 102
/* ### 21 bits */ /* b20-19 = object ID, (0-3) max 4 objects represented. */
		  /* b18-10 = distance to object from vehicle reference   */
		  /*    point.  Range is 0-511 in decimeters.             */
		  /* b9-0 = angle to object from vehicle reference point. */
		  /*   Range is 0-1023.  Forward on the vehicle centerline */
		  /*   is 0 degrees with values increasing around the */
		  /*   circle in the clockwise direction, 1023 = 359.65 deg */


#define PKT_CMD_CCONTROL 103        /* Cruise Control */
/* ### 1 bit */ /* 0-disengaged, 1-engaged */

#define PKT_STAT_CCONTROL 104       /* Cruise Control */
/* ### 1 bit */ /* 0-disengaged, 1-engaged */

#define PKT_CMD_CLEAR_ERR 105
/* ### 1 bit */ /* 0-no change in error status, 1-clear error signal */

#define PKT_CMD_THROTTLE1 106       /* Second throttle */
/* ### 7 bits */    /* 0 = no throttle, 127 = full throttle */

    /* The following were added for RATLER, 01-93 */

#define PKT_STAT_THROTTLE1 107      /* Second throttle */
/* ### 7 bits */    /* 0 = no throttle, 127 = full throttle */

#define PKT_CMD_BRAKE1 108          /* Second brake */
/* ### 7 bits */        /* 0 = no brake, 127 = full brake */

#define PKT_STAT_BRAKE1 109         /* Second brake */
/* ### 7 bits */        /* 0 = no brake, 127 = full brake */

#define PKT_CMD_GEAR1 110           /* Second transmission */
/* ### 3 bits */         /* 0 = park, 1 = rev, 2 = neu, 3 = 1st, 4 = 2nd */
			 /* 5 = 3rd,  6 = 4th, 7 = no gear */

#define PKT_STAT_GEAR1 111          /* Second transmission */
/* ### 3 bits */         /* 0 = park, 1 = rev, 2 = neu, 3 = 1st, 4 = 2nd */
			 /* 5 = 3rd,  6 = 4th, 7 = no gear */

#define PKT_CMD_PACKAGE0 112    /* Scientific/weapons package 0 */
/* ### 4 bits */         /* b3-0 = package command */
			 /*        0000   =   Off  */
			 /*        0011   =   On   */
			 /*        0110   =   Stby */
			 /*        0101, 1100, 1111, 1010, 1001 undefined */
			 /*        Commands are Hamming distance 2 apart, */
			 /*        for error detection purposes. */

#define PKT_STAT_PACKAGE0 113
/* ### 4 bits */         /* b3-0 = package status  */
			 /*        0000   =   Off  */
			 /*        0011   =   On   */
			 /*        0110   =   Stby */
			 /*        0101, 1100, 1111, 1010, 1001 undefined */

#define PKT_CMD_PACKAGE1 114    /* Scientific/weapons package 1 */
/* ### 4 bits */         /* b3-0 = package command */
			 /*        0000   =   Off  */
			 /*        0011   =   On   */
			 /*        0110   =   Stby */
			 /*        0101, 1100, 1111, 1010, 1001 undefined */
			 /*        Commands are Hamming distance 2 apart, */
			 /*        for error detection purposes. */

#define PKT_STAT_PACKAGE1 115
/* ### 4 bits */         /* b3-0 = package status  */
			 /*        0000   =   Off  */
			 /*        0011   =   On   */
			 /*        0110   =   Stby */
			 /*        0101, 1100, 1111, 1010, 1001 undefined */

#define PKT_CMD_PACKAGE2 116    /* Scientific/weapons package 2 */
/* ### 4 bits */         /* b3-0 = package command */
			 /*        0000   =   Off  */
			 /*        0011   =   On   */
			 /*        0110   =   Stby */
			 /*        0101, 1100, 1111, 1010, 1001 undefined */
			 /*        Commands are Hamming distance 2 apart, */
			 /*        for error detection purposes. */

#define PKT_STAT_PACKAGE2 117
/* ### 4 bits */         /* b3-0 = package status  */
			 /*        0000   =   Off  */
			 /*        0011   =   On   */
			 /*        0110   =   Stby */
			 /*        0101, 1100, 1111, 1010, 1001 undefined */

#define PKT_CMD_PACKAGE3 118    /* Scientific/weapons package 3 */
/* ### 4 bits */         /* b3-0 = package command */
			 /*        0000   =   Off  */
			 /*        0011   =   On   */
			 /*        0110   =   Stby */
			 /*        0101, 1100, 1111, 1010, 1001 undefined */
			 /*        Commands are Hamming distance 2 apart, */
			 /*        for error detection purposes. */

#define PKT_STAT_PACKAGE3 119
/* ### 4 bits */         /* b3-0 = package status  */
			 /*        0000   =   Off  */
			 /*        0011   =   On   */
			 /*        0110   =   Stby */
			 /*        0101, 1100, 1111, 1010, 1001 undefined */

#define PKT_STAT_INCLINE2 120   /* Second inclination angle status     */
/* ### 7 bits */
    /* 0 = -64 degrees, if pitch nose down if roll right up       */
	 /* 64 = level or 0 degrees                                    */
    /* 127 = +63 degrees, if pitch nose up if roll left up        */

#define PKT_CMD_GPS_LAT 121     /* GPS Latitude Reference Command        */
/* ### 14 bits */
    /* bit 13      = north/south bit, 0 = north, 1 = south               */
    /* bits 12 - 6 = degrees of latitude, 0 - 89 (90-127 undefined)      */
    /* bits 5 - 0  = minutes of latitude, 0 - 59 (60-63 undefined)       */

#define PKT_STAT_GPS_LAT 122     /* GPS Latitude Reference Status        */
/* ### 14 bits */
    /* bit 13      = north/south bit, 0 = north, 1 = south               */
    /* bits 12 - 6 = degrees of latitude, 0 - 89 (90-127 undefined)      */
    /* bits 5 - 0  = minutes of latitude, 0 - 59 (60-63 undefined)       */

#define PKT_CMD_GPS_LONG 123     /* GPS Longitude Reference Command      */
/* ### 15 bits */
    /* bit 14      = east/west bit, 0 = west, 1 = east of Grn'ich Merid  */
    /* bits 13 - 6 = degrees of latitude, 0 - 179 (180-255 undefined)    */
    /* bits 5 - 0  = minutes of latitude, 0 - 59 (60-63 undefined)       */

#define PKT_STAT_GPS_LONG 124    /* GPS Longitude Reference Status       */
/* ### 15 bits */
    /* bit 14      = east/west bit, 0 = west, 1 = east of Grn'ich Merid  */
    /* bits 13 - 6 = degrees of latitude, 0 - 179 (180-255 undefined)    */
    /* bits 5 - 0  = minutes of latitude, 0 - 59 (60-63 undefined)       */

#define PKT_CMD_GPS_ELEV 125     /* GPS Elevation Reference Command      */
/* ### 7 bits */
    /* Elevation values are referenced from mean sea level (MSL) in      */
    /* hundreds of meters.  Elevation = ((RCP value - 10) * 100),        */
    /* range is -1000 to 11700 meters.                                   */

#define PKT_STAT_GPS_ELEV 126     /* GPS Elevation Reference Status      */
/* ### 7 bits */
    /* Elevation values are referenced from mean sea level (MSL) in      */
    /* hundreds of meters.  Elevation = ((RCP value - 10) * 100),        */
    /* range is -1000 to 11700 meters.                                   */

#define PKT_CMD_LAT_DELTA 127     /* GPS Latitude Delta Command          */
/* ### 19 bits */
    /* bits 18 - 0 = latitude delta in minutes and decimal minutes.      */
    /*               Values range 0 to 5.24287 minutes at 0.00001        */
    /*               minutes per tick.  The delta value contains         */
    /*               an offset of 2.5 minutes inserted on the xmitting   */
    /*               end which must be subtracted by the receiving end   */
    /*               to account for negative deltas:                     */
    /*                 Delta = (GPS Posn - GPS Ref + 2.5) * 100000       */

#define PKT_STAT_LAT_DELTA 128     /* GPS Latitude Delta Status          */
/* ### 19 bits */
    /* bits 18 - 0 = latitude delta in minutes and decimal minutes.      */
    /*               Values range 0 to 5.24287 minutes at 0.00001        */
    /*               minutes per tick.  The delta value contains         */
    /*               an offset of 2.5 minutes inserted on the xmitting   */
    /*               end which must be subtracted by the receiving end   */
    /*               to account for negative deltas:                     */
    /*                 Delta = (GPS Posn - GPS Ref + 2.5) * 100000       */


#define PKT_CMD_LONG_DELTA 129     /* GPS Longitude Delta Command        */
/* ### 19 bits */
    /* bits 18 - 0 = longitude delta in minutes and decimal minutes.     */
    /*               Values range 0 to 5.24287 minutes at 0.00001        */
    /*               minutes per tick.  The delta value contains         */
    /*               an offset of 2.5 minutes inserted on the xmitting   */
    /*               end which must be subtracted by the receiving end   */
    /*               to account for negative deltas:                     */
    /*                 Delta = (GPS Posn - GPS Ref + 2.5) * 100000       */

#define PKT_STAT_LONG_DELTA 130     /* GPS Longitude Delta Status        */
/* ### 19 bits */
    /* bits 18 - 0 = longitude delta in minutes and decimal minutes.     */
    /*               Values range 0 to 5.24287 minutes at 0.00001        */
    /*               minutes per tick.  The delta value contains         */
    /*               an offset of 2.5 minutes inserted on the xmitting   */
    /*               end which must be subtracted by the receiving end   */
    /*               to account for negative deltas:                     */
    /*                 Delta = (GPS Posn - GPS Ref + 2.5) * 100000       */

#define PKT_CMD_ELEV_DELTA 131     /* GPS Elevation Delta Command        */
/* ### 14 bits */
    /* bit 13 = sign bit, 1 = negative value, 0 = positive values.       */
    /* bits 12 - 0 = magnitude of delta elevation with resolution of     */
    /*               1.25 centimeters.  Range is -102.3875 to +102.3875  */
    /*               meters.                                             */

#define PKT_STAT_ELEV_DELTA 132     /* GPS Elevation Delta Status        */
/* ### 14 bits */
    /* bit 13 = sign bit, 1 = negative value, 0 = positive values.       */
    /* bits 12 - 0 = magnitude of delta elevation with resolution of     */
    /*               1.25 centimeters.  Range is -102.3875 to +102.3875  */
    /*               meters.                                             */

#define PKT_DIFF_WORD 133     /* GPS Differential Correction Word   */
/* ### 30 bits       */
    /* bit 29 - 0 = defined a variety of message types to be used for    */
    /*              differential correction in a GPS system.  Refere to  */
    /*              "Radio Technical Commision for Maritime Services     */
    /*              (RTCM) Paper 134-89/SC 104-68, RTCM P.). Box 19087,  */
    /*              Washington DC 20036 for details.                     */

#define PKT_STAT_OIL_LEVEL 134     /* Oil Level Status                   */
/* ### 4 bits */
    /* bit 3 = Engine oil high level sensor, 1 = Engine oil full         */
    /* bit 2 = Engine oil low level sensor, 1 = Engine oil low           */
    /* bit 1 = Transmission oil high level sensor, 1 = oil full          */
    /* bit 0 = Transmission oil low level sensor, 1 = oil low            */

#define PKT_STAT_VOLTAGE 135     /* Voltage Monitor Status               */
/* ### 14 bits */
    /* bits 13-8 = Voltage monitor ID, value is 0 -63.  Application      */
    /*             should use RCP hook functions to prevent subsequent   */
    /*             data received from overwriting values.                */
    /* bits 7-0 = Voltage value, value is 0 - 255, scaling is            */
    /*            application defined.                                   */

#define PKT_STAT_CURRENT 136     /* Current Monitor Status               */
/* ### 18 bits */
    /* bits 17-12 = Current monitor ID, value is 0 -63.  Application     */
    /*             should use RCP hook functions to prevent subsequent   */
    /*             data received from overwriting values.                */
    /* bits 11-0 = Current value, value is 0 - 4095, scaling is          */
    /*             application defined.                                  */

#define PKT_STAT_TOTAL_OD 137     /* Total distance traveled by vehicle. */
/* ### 18 bits */
    /* bits 16-0 = Total distance logged on vehicle in Km, range is      */
    /*             0 - 262143 kilometers.                                */

#define PKT_CMD_YEAR 138    /* Set Year Command                          */
/* ### 7 bits */
    /* bits 6-0 = year in century, range of values is 0..99.  Values     */
    /*            outside this range (100-127) are not used.             */

#define PKT_STAT_YEAR 139   /* Year Status                               */
/* ### 7 bits */
    /* bits 6-0 = year in century, range of values is 0..99.  Values     */
    /*            outside this range (100-127) are not used.             */

#define PKT_CMD_TIME_OF_DAY 140    /* Time of Day Command                */
/* ### 17 bits */
    /* bits 16-0 = number of seconds from some reference, often local    */
    /*             midnight (e.g., midnight = 0, 00:00:01 = 1, etc.)     */
    /*             Range of values is 0..86399 to cover one terrestrial  */
    /*             24-hour day.  Values outside this range can be used   */
    /*             but do not have a standard meaning in a 24-hour clock.*/

#define PKT_STAT_TIME_OF_DAY 141   /* Time of Day Status                 */
/* ### 17 bits */
    /* bits 16-0 = number of seconds from some reference, often local    */
    /*             midnight (e.g., midnight = 0, 00:00:01 = 1, etc.)     */
    /*             Range of values is 0..86399 to cover one terrestrial  */
    /*             24-hour day.  Values outside this range can be used   */
    /*             but do not have a standard meaning in a 24-hour clock.*/

#define PKT_CMD_MILLISECONDS 142  /* Milliseconds Command                */
/* ### 10 bits */
    /* bits 9-0 = number of milliseconds from some reference, usually    */
    /*             a one-second tick.  Nominal range of values is 0..999,*/
    /*             although 1000..1023 can still be used.                */

#define PKT_STAT_MILLISECONDS 143  /* Milliseconds Status                */
/* ### 10 bits */
    /* bits 9-0 = number of milliseconds from some reference, usually    */
    /*             a one-second tick.  Nominal range of values is 0..999,*/
    /*             although 1000..1023 can still be used.                */

#define PKT_CMD_HORN 144  /* Horn Command                                */
/* ### 1 bit */    /* 0 = horn off, 1 = horn on */

#define PKT_STAT_HORN 145 /* Horn Status                                 */
/* ### 1 bit */    /* 0 = horn off, 1 = horn on */

#define PKT_STAT_ELAPSED_TIME 146  /* Elapsed Time Status                */
/* ### 19 bits */
    /* bits 18-15 = ID of condition being measured (e.g., engine running)*/
    /*              Application should use RCP hook functions to prevent */
    /*              subsequent data received from overwriting values.    */
    /* bits 14-0  = Elapsed time in tenths of hours or other application-*/
    /*              defined unit.  Max value with tenths is 3276.7 hours.*/

#define PKT_CMD_SET_TIMER 147  /* Set Timer Command                      */
/* ### 19 bits */
    /* bits 18-16 = timer ID from 0 through 7.                           */
    /* bits 15-0  = timer value in application-defined units.  This      */
    /*              gives 45.5 days at minute resolution, or 18.2 hours  */
    /*              at second resolution, or just over a minute at       */
    /*              millisecond resolution.                              */

#define PKT_STAT_TIMER 148  /* Timer Status                              */
/* ### 19 bits */
    /* bits 18-16 = timer ID from 0 through 7.                           */
    /* bits 15-0  = timer value in application-defined units.  This      */
    /*              gives 45.5 days at minute resolution, or 18.2 hours  */
    /*              at second resolution, or just over a minute at       */
    /*              millisecond resolution.                              */

#define PKT_CMD_FLIR 149  /* FLIR Command                                */
/* ### 8 bits */
    /* bit 7    = FLIR power, 0 = off, 1 = on                            */
    /* bits 6-5 = gain, 3 = undefined, 2 = high, 1 = medium, 0 = low     */
    /* bits 4-3 = phase, 3 = undefined, 2 = increase, 1 = decrease,      */
    /*            0 = no change                                          */
    /* bits 2-1 = brightness, 3 = undefined, 2 = increase, 1 = decrease, */
    /*            0 = no change                                          */
    /* bit 0    = black/white, 0 = black hot, 1 = white hot              */

#define PKT_STAT_DATA0_RX_STRENGTH 150
/* ### 5 bits */
    /* bits 5-0 = receiver signal strength indicator.  Value is 0-31     */
    /*            indicating proportional signal strength.  0=no signal, */
    /*            31 = max signal.  The application will define specific */
    /*            units if necessary.                                    */

#define PKT_STAT_DATA1_RX_STRENGTH 151
/* ### 5 bits */
    /* bits 5-0 = receiver signal strength indicator.  Value is 0-31     */
    /*            indicating proportional signal strength.  0=no signal, */
    /*            31 = max signal.  The application will define specific */
    /*            units if necessary.                                    */

#define PKT_STAT_VIDEO0_RX_STRENGTH 152
/* ### 5 bits */
    /* bits 5-0 = receiver signal strength indicator.  Value is 0-31     */
    /*            indicating proportional signal strength.  0=no signal, */
    /*            31 = max signal.  The application will define specific */
    /*            units if necessary.                                    */

#define PKT_STAT_VIDEO1_RX_STRENGTH 153
/* ### 5 bits */
    /* bits 5-0 = receiver signal strength indicator.  Value is 0-31     */
    /*            indicating proportional signal strength.  0=no signal, */
    /*            31 = max signal.  The application will define specific */
    /*            units if necessary.                                    */

#define PKT_CMD_LOGGING 154
/* ### 2 bits */
    /* 0 = turn logging OFF */
    /* 1 = turn logging ON */
    /* 2 = pause logging (makes sense only if currently logging */
    /* 3 = not used */

#define PKT_STAT_LOGGING 155
/* ### 2 bits */
    /* 0 = logging OFF */
    /* 1 = logging ON */
    /* 2 = logging PAUSED */
    /* 3 = not used */

#define PKT_STAT_WHEEL0_ENCODER 156
/* ### 20 bits */
    /* 0       = -524288 counts (reverse direction) */
	 /* 52488   = 0 counts */
    /* 1048575 = +524287 counts (forward direction) */

#define PKT_STAT_WHEEL1_ENCODER 157
/* ### 20 bits */
    /* 0       = -524288 counts (reverse direction) */
	 /* 52488   = 0 counts */
    /* 1048575 = +524287 counts (forward direction) */

#define PKT_STAT_WHEEL2_ENCODER 158
/* ### 20 bits */
    /* 0       = -524288 counts (reverse direction) */
	 /* 52488   = 0 counts */
    /* 1048575 = +524287 counts (forward direction) */

#define PKT_STAT_WHEEL3_ENCODER 159
/* ### 20 bits */
    /* 0       = -524288 counts (reverse direction) */
	 /* 52488   = 0 counts */
    /* 1048575 = +524287 counts (forward direction) */

#define PKT_CMD_HI_RES_THROTTLE0 160
/* ### 12 bits */
    /* 0 = no throttle, 4095 = full throttle */

#define PKT_CMD_HI_RES_THROTTLE1 161
/* ### 12 bits */
    /* 0 = no throttle, 4095 = full throttle */

#define PKT_CMD_SEND_IMAGE_TRIPLE 162
/* ### 1 bit */
    /* 1 = send RATLER image triple, 0 = do not send image triple */

#define PKT_CMD_CALIBRATE_NOW 163
/* ### 1 bit */
    /* 1 = calibrate now, 0 = do not calibrate now */

#define PKT_STAT_CALIBRATION 164
/* ### 1 bit */
    /* 1 = calibration done, 0 = calibration not done */


/*************************************************************************
*                                                                        *
* !!! DON'T FORGET TO UPDATE #define MAX_PACKETS IN rcpdef.h !!!!        *
*                                                                        *
*  It should be at least one more than the largest pkt number above.     *
*                                                                        *
* ! If MAX_PACKETS does change, then you must also recompile GETBITS.C ! *
*                                                                        *
*************************************************************************/

#endif
