/*
   FILE - RCPERRS.H

   Frank Wunderlin, Wendy Amai
   Sandia National Laboratories Dept. 9616
   (505) 844-5903

   This file contains errors that are returned by the robotic communication
   protocol functions.

   Modified:  waa 2-9-90 -- Changed to enum typedef from #defines.
*/
#ifndef RCPERRS_H
#define RCPERRS_H

typedef enum {

   RCP_SUCCESS,       /* no errors encountered */
   FUNC_ADDR_ERR,     /* function address = NULL was encountered */
   PKT_ADDR_ERR,      /* packet address = NULL was encountered */
   PARM_ERR,          /* Invalid parameter, or parameter out of range */
   PKT_RANGE_ERR,     /* Packet number out of range 0 to MAX_PACKETS-1 */
   BLOCK_RANGE_ERR,   /* Block number out of range 0 to MAX_BLOCKS-1 */
   MEM_ERR,
   CHECKSUM_ERR,      /* checksum did not equal data bytes */
   BLKS_EXCEEDED_ERR, /* attempt to define > MAX_BLOCKS blocks */
   BLOCK_DEF_ERR,
   MODULE_ADD_ERR,    /* block defined with more packets than exist */
   INDEX_ERR,         /* block defined with more packets than exist */
   DUPLICATE_ERR      /* attempt to map > 1 job to comm job array */

} RCP_ERRORTYPE;

#endif