/*
   FILE - RCPDEF.H

   Frank Wunderlin, Wendy Amai
   Sandia National Laboratories Dept. 9616
   (505) 844-5903

   This file contains basic definitions used by the robotic communication
   protocol.

   Modified:
      fkw  12-10-93 -- Redefined blocks 64 - 72.
*/

#ifndef RCPDEFDOTH
#define RCPDEFDOTH

#define FALSE 0
#define TRUE 1

#define SIZEBYTE    8   /* number of bits per byte  */
#define CHAR_BIT    8   /*   "     "  "    "    "   */
#define SIZELONG   32   /* machine dependent number of bits in a long int */
#define HIGHBIT  0x80   /* high bit set in byte */

#define MOTOROLA    1   /* flag used for machine dependent storage of ints */

#define MAX_BLOCKS   64   /* maximum number of configurable blocks */
#define MAX_BITS     32   /* maximum number of bits in a data packet */
#define MAX_JOBS     33   /* maximum number of jobs assigned to data sets */
                          /*   see rcpblock.h */
#define STREAM_MAX   64   /* maximum number of blocks in a stream */
#define MAX_PACKETS 170   /* maximum number of defined data packets */


/*
     Fixed commands
 */
#define FIXED_LOW             DESELECT_RV   /* For range information */
#define DESELECT_RV           64
#define SELECT_RV             65
#define DEFINE_BLOCK_SEQUENCE 66
#define PKT_NOT_SUPPORTED     67
#define REPEAT_MESSAGE        68
#define RCP_XON               69
#define RCP_XOFF              70
#define QUERY_BLOCK           71
#define DEFINE_PKTS_INBLOCK   72
#define ACK_CMD_RECEIVED      73
#define QUERY_WITH_ID         74
#define FIXED_HIGH            QUERY_WITH_ID  /* For range information */

/* Returns 1 if given block number is a fixed command */
#define is_fixed_command(n)   ((n)>=FIXED_LOW && (n)<=FIXED_HIGH)

#endif
