/***************************************************************************
*
*  dm5406.h -- Prototypes and defines for AD conversion routines for
*              RTD 5406 board
*
*  At least one file that includes this file must declare the variable
*
*  DM5406_ERROR_TYPE   _dm5406_error
*
*  It used to pass error codes from functions that return a range of
*  values anyway.
*
*  Created:  waa, 12-22-93
*
***************************************************************************/

/* Miscellaneous defines */
#define FALSE 0
#define TRUE  1

/* Analog channel defines */
#define MIN_AD_CHANNEL    1
#define MAX_AD_CHANNEL    16
#define is_valid_ad_channel(n)  ((n)>=MIN_AD_CHANNEL && (n)<=MAX_AD_CHANNEL)

#define DEFAULT_BASE      0x300
#define STATUS_ADDR       (dm5406_base + 0)
#define CONVERT_ADDR      (dm5406_base + 0)
#define DATA_ADDR         (dm5406_base + 1) /* First MSB, then LSB */
#define RESET_ADDR        (dm5406_base + 2)
#define SCAN_ADDR         (dm5406_base + 3)
#define CHANNEL_ADDR      (dm5406_base + 5)


/* Digital port defines (8255 Programmable Peripheral Interface) */
/* Note that Port B is unavailable for digital I/O */
enum
{
   DIO_PORT_A,
   DIO_PORT_C
};
#define is_valid_dio_port(n)  ((n)>=DIO_PORT_A && (n)<=DIO_PORT_C)

#define PPI_PORT_A        (dm5406_base + 4)
#define PPI_PORT_C        (dm5406_base + 6)
#define PPI_CONTROL_ADDR  (dm5406_base + 7)


/* Timer control defines (8254 Programmable Interval Timer) */
#define TC0               (dm5406_base + 8)
#define TC1               (dm5406_base + 9)
#define TC2               (dm5406_base + 10)
#define TIMER_CONTROL_ADDR (dm5406_base + 11)

/* Error returns for _ad_error */
typedef enum
{
   DM5406_OKAY,
   DM5406_CONVERSION_INCOMPLETE,
   DM5406_INVALID_CHANNEL,
   DM5406_INVALID_DIO_PORT
} DM5406_ERROR_TYPE;


extern DM5406_ERROR_TYPE _dm5406_error; /* For passing error values */


/* Function prototypes: */
DM5406_ERROR_TYPE select_ad_channel(int channel);
void init_dm5406 (int base_addr, int ppi_mode, int ad_enable);
int  get_dio (int port);
int  get_ad(void);
int  get_ad(int channel);
