/*************************************************************************
*
*  cdstruc.h -- Contains typedefs for structures that are likely to be
*               used throughout the RATLER CDS software.
*
*  Modified:
*    WAA, 06-16-95 -- Changed the fuel packet to the battery voltage pkt.
*                     Fuel pkt had 4 bits, battery voltage has 8 bits,
*                     so leaving as a byte.
*                     Changed accum_odom from int to unsigned int.
*
**************************************************************************/

#ifndef CDSTRUCDOTH
#define CDSTRUCDOTH

#include "cdsdef.h"

typedef struct
{
   int   opcode;  /* Has task-specific meaning */
   union
   {
      byte data[10]; /* Actual individual data bytes */
      char *buffer;  /* Pointer to a buffer containing data */
   } u;

} MESSAGESTRUCT;

typedef struct
{
   long pan;
   long xpos;
   long ypos;
   int  tilt;
   byte scale_speed;
   byte vehmode;

   byte kill;
   byte parking_brake;

   byte left_throttle;
   byte right_throttle; /* aka THROTTLE1 */

   byte left_gear;
   byte right_gear;     /* aka GEAR1 */

   byte package;
   byte video_power;

} VEHCMD;

typedef struct
{
   long pan;
   long xpos;
   long ypos;
   int  heading;
   int  altimeter;
   int  eng_temp;
   unsigned int accum_odom;
   byte vehmode;
   byte kill;

   byte video_power;
   byte parking_brake;

   byte abort_code;
   byte left_pitch;

   byte roll;
   byte speed;

   byte battery_voltage;
   byte right_pitch;

   byte odometer;    /* incremental */

   byte package;
   byte scale_speed;

} VEHSTAT;

#endif
