/*************************************************************************
* $include$="\ratler\common\h\pdscan.h"
*
*	!name!
*
* cdsdef.h
*
*	!paths!
*	files\header
*
*************************************************************************
*!0!
*
*  cdsdef.h -- Contains global typedefs and defines for the RATLER CDS
*              software.
*!end!
**************************************************************************/


#ifndef CDSDEFDOTH
#define CDSDEFDOTH

typedef unsigned char byte;

#define OKAY         1

#define ON           1
#define OFF          0

#define VEHICLE_PORT  0  /* RCP port number */

/* Veh nums range from MIN_VEH_NUM through MAX_VEH_NUM */
#define MIN_VEH_NUM   1
#define MAX_VEH_NUM   4
#define NUM_VEHICLES (MAX_VEH_NUM - MIN_VEH_NUM + 1)
#define BROADCAST_VEH_NUM  127

/* Veh ID's range from MIN_VEH_ID through MAX_VEH_ID */
#define MIN_VEH_ID          0
#define MAX_VEH_ID         15
#define BROADCAST_VEH_ID  127
#define INVALID_VEH_ID    (-1)

/* For determining a valid vehicle number ID or number */
#define is_valid_vehicle_id(n)  (((n)>=MIN_VEH_ID && (n)<=MAX_VEH_ID) \
                                 || (n) == BROADCAST_VEH_ID)
#define is_valid_vehicle_num(n) ((n)>=MIN_VEH_NUM && (n)<=MAX_VEH_NUM)

/* For printed messages */
#define STRBUFLEN    80    /* Number of bytes found in a text buffer */
typedef enum
{
   INFORMATIONAL,
   WARNING,
   FATAL,
   DEVELOPMENTAL_INFORMATIONAL,
   DEVELOPMENTAL_WARNING,
   DEVELOPMENTAL_FATAL,
   MAX_TEXTMSGTYPE

} TEXTMSGTYPE;

/* For RCP blocks */
#define RCPBUFLEN    20    /* Max number of bytes in RCP block */

#endif
