/*****************************************************************************
 * PROJECT: TCA
 *
 * (c) Copyright Richard Goodwin, 1995. All rights reserved.
 *
 * FILE: x11Utils.c
 *
 * ABSTRACT:
 * 
 * This file provides routines having the X11 main loop handle tca events.
 *
 * ADAPTED FROM XAVIER SOFTWARE TO FACILITATE ADDING I/O TO MODULES.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/utils/x11Utils.c,v $ 
 * $Revision: 1.5 $
 * $Date: 1996/02/21 18:36:02 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: x11Utils.c,v $
 * Revision 1.5  1996/02/21  18:36:02  rich
 * Use new routine for handling input.
 *
 * Revision 1.4  1996/02/10  16:54:22  rich
 * Made private functions static and fixed some forward declarations.
 *
 * Revision 1.3  1996/01/12  00:56:01  rich
 * Simplified GNUmakefiles. Fixed header include problem with release 8.3.
 *
 * Revision 1.2  1995/06/14  03:26:22  rich
 * Added DBMALLOC_DIR.
 * Fixed problems with multiple connections.
 *
 * Revision 1.1  1995/04/07  05:16:39  rich
 * Added x11Utils to connect tca to the X11 main loop.
 * Added sim device to use in creating simulators.
 *
 *
 *****************************************************************************/

#include "tca/libc.h"
#include "tca.h"
#include "ezx.h"
#include "handlers.h"
#include "timeUtils.h"
#include "devUtils.h"
#include "x11Utils.h"

/*****************************************************************************
 * Global constants 
 *****************************************************************************/

/*****************************************************************************
 * Global variables 
 *****************************************************************************/

static XtAppContext Keep_Context = NULL;
static XtInputId X_Inputs[FD_SETSIZE];

/*****************************************************************************
 *
 * FUNCTION: void X11_defaultOutputHnd(int fd, long chars_available)
 *
 * DESCRIPTION: Handles X11 events.
 *
 * INPUTS:
 *
 * OUTPUTS: 
 *
 * HISTORY:
 *
 *****************************************************************************/
static void tcaCallbackProc(XtPointer closure, int* fd, XtInputId* id);

static void updateXInputs(void)
{
  static fd_set X11_TCA = NO_FDS;
  int i;
  fd_set *tcaFDS;

  tcaFDS = tcaGetConnections();
  
  for(i=0;i<FD_SETSIZE; i++) {
    if (FD_ISSET(i,&X11_TCA) && !FD_ISSET(i,tcaFDS)) {
      /* Remove connection that is no longer valid. */
      if (X_Inputs[i] != 0) {
	XtRemoveInput(X_Inputs[i]);
	X_Inputs[i] = 0;
      }
      FD_CLR(i,&X11_TCA);
    } else if (!FD_ISSET(i,&X11_TCA) && FD_ISSET(i,tcaFDS)) {
      /* Add a new connection. */
      XtAppAddInput(Keep_Context, i, 
		    (XtPointer)(XtInputReadMask | XtInputExceptMask),
		    tcaCallbackProc, NULL);
    }
  }

}

static void tcaCallbackProc(XtPointer closure, int* fd, XtInputId*	id)
{
  tcaHandleFdInput(*fd);
  updateXInputs();
}

void connectTCA_X11(XtAppContext app_context)
{
  int i;

  Keep_Context = app_context;
  for(i=0;i<FD_SETSIZE; i++) {
    X_Inputs[i] = 0;
  }
  updateXInputs();
}
