/*****************************************************************************
 * PROJECT: TCA
 *
 * (c) Copyright Richard Goodwin, 1995. All rights reserved.
 *
 * FILE: x11Dev.h
 *
 * ABSTRACT:
 * 
 * This file provides routines for connecting X11 to the set of device
 * interfaces (see devUtils.{c,h}).
 *
 * ADAPTED FROM XAVIER SOFTWARE TO FACILITATE ADDING I/O TO MODULES.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/utils/x11Dev.h,v $ 
 * $Revision: 1.7 $
 * $Date: 1996/08/05 16:15:17 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: x11Dev.h,v $
 * Revision 1.7  1996/08/05  16:15:17  rich
 * Added Brooke Wallace's changes to get devUtils to work with the access bus.
 *
 * Revision 1.6  1996/01/12  00:55:59  rich
 * Simplified GNUmakefiles. Fixed header include problem with release 8.3.
 *
 * Revision 1.5  1995/12/15  01:32:12  rich
 * Added routines to free data, devFreeDev and devFreeLineBuffer.
 * Added a parameter to set the behaviour when there is a signal, but no
 * characters to read on a socket.  Added routines to connect fds for
 * reading or sending only.  This is useful when spawning sub-processes and
 * you want to manage stdin, stdout and stderr.  This is used by nanny.
 * Added EZX_DestroyPopupPrompt and EZX_CenterPopup.
 *
 * Revision 1.4  1995/08/05  23:23:41  rich
 * Added functional interface to devUtils.  See the README for details.
 *
 * Revision 1.3  1995/04/07  05:11:26  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Moved global variables into the c files and got rid of #define DECLARE_...
 * Now works with xavier stuff.
 *
 * Revision 1.2  1995/04/04  19:48:35  rich
 * Added sgi support.
 * Changed setAlarm to setTimer.
 * Numerous improvements and bug fixes in devUtils.
 *
 * Revision 1.1  1995/03/30  15:53:41  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Added ezx library and the devutils library.
 *
 *
 *****************************************************************************/

#ifndef X11_DEV_LOADED
#define X11_DEV_LOADED

#ifndef EZX_H
#include "tca/ezx.h"
#endif

#ifndef DEVUTIL_LOADED
#include "tca/devUtils.h"
#endif


extern XtAppContext app_context;

extern DEV_PTR    X11_device;

#ifdef __cplusplus
extern "C" {
#endif

void X11_defaultOutputHnd(int fd, long chars_available);

void x11_connect(int connection);


#ifdef __cplusplus
}
#endif


#endif /* X11_DEV_LOADED */
