/*****************************************************************************
 * PROJECT: TCA
 *
 * (c) Copyright Richard Goodwin, 1995. All rights reserved.
 *
 * FILE: x11Dev.c
 *
 * ABSTRACT:
 * 
 * This file provides routines for connecting X11 to the set of device
 * interfaces (see devUtils.{c,h}).
 *
 * ADAPTED FROM XAVIER SOFTWARE TO FACILITATE ADDING I/O TO MODULES.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/utils/x11Dev.c,v $ 
 * $Revision: 1.10 $
 * $Date: 1996/01/12 00:55:58 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: x11Dev.c,v $
 * Revision 1.10  1996/01/12  00:55:58  rich
 * Simplified GNUmakefiles. Fixed header include problem with release 8.3.
 *
 * Revision 1.9  1995/12/15  01:32:10  rich
 * Added routines to free data, devFreeDev and devFreeLineBuffer.
 * Added a parameter to set the behaviour when there is a signal, but no
 * characters to read on a socket.  Added routines to connect fds for
 * reading or sending only.  This is useful when spawning sub-processes and
 * you want to manage stdin, stdout and stderr.  This is used by nanny.
 * Added EZX_DestroyPopupPrompt and EZX_CenterPopup.
 *
 * Revision 1.8  1995/10/07  19:11:45  rich
 * Pre-alpha release of tca-8.2.
 * Added PROJECT_DIR. Changed devIsConnected to devHasFd.
 *
 * Revision 1.7  1995/08/14  21:35:06  rich
 * Changed devReadN and devWriteN to take the same parameters as read and
 * write.  This allows macro substitution for the system calls.
 * Added "dev" prefix to everything.  Some minor fixes.
 *
 * Revision 1.6  1995/08/05  23:23:39  rich
 * Added functional interface to devUtils.  See the README for details.
 *
 * Revision 1.5  1995/06/14  03:26:19  rich
 * Added DBMALLOC_DIR.
 * Fixed problems with multiple connections.
 *
 * Revision 1.4  1995/06/01  00:28:29  rich
 * Use TIME_MAX rather than LONG_MAX for timeouts.
 * Fix some problems with devUtils processOutput.
 *
 * Revision 1.3  1995/04/07  05:11:25  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Moved global variables into the c files and got rid of #define DECLARE_...
 * Now works with xavier stuff.
 *
 * Revision 1.2  1995/04/04  19:48:29  rich
 * Added sgi support.
 * Changed setAlarm to setTimer.
 * Numerous improvements and bug fixes in devUtils.
 *
 * Revision 1.1  1995/03/30  15:53:40  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Added ezx library and the devutils library.
 *
 *
 * 30-Jan-1993 Richard Goodwin Created.
 *
 *****************************************************************************/

#include "tca/libc.h"

#include <X11/Xfuncproto.h>
#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/Xlib.h>

#include <X11/Xatom.h>
#include <X11/IntrinsicP.h>
#include <X11/Core.h>
#include <X11/CoreP.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>

#include <X11/Xaw/Label.h>
#include <X11/Xaw/Viewport.h>

#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Dialog.h>

#include "handlers.h"
#include "timeUtils.h"
#include "devUtils.h"
#include "x11Dev.h"

/*****************************************************************************
 * Global constants 
 *****************************************************************************/

/*****************************************************************************
 * Global variables 
 *****************************************************************************/

XtAppContext app_context;

DEV_PTR    X11_device = NULL;
/*
{
  NOT_CONNECTED,
  FALSE,
  { "", DEFAULT_PORT},
  { "X11 server", DEFAULT_BAUD},
  "X11 server",
  NO_FDS,
  NO_FDS,
  LISTENING | TALKING,
  FALSE,
  (FILE *) NULL,
  &devConnections,
  (DEVICE_OUTPUT_HND) X11_defaultOutputHnd,
  Null_Handler,  
  {TIME_MAX, 0},
  Null_Handler,  
  {0, 0},
  {TIME_MAX, 0},
  (void (*)(DEV_PTR)) NULL,
  (void (*)(DEV_PTR)) NULL,
  (void (*)(DEV_PTR)) NULL,
};
*/

/*****************************************************************************
 *
 * FUNCTION: void X11_defaultOutputHnd(int fd, long chars_available)
 *
 * DESCRIPTION: Handles X11 events.
 *
 * INPUTS:
 *
 * OUTPUTS: 
 *
 * HISTORY:
 *
 *****************************************************************************/

void X11_defaultOutputHnd(int fd, long chars_available)
{
  XtInputMask mask;
  
  while ((mask = (XtAppPending(app_context) & (XtIMXEvent | XtIMTimer))) != 0)
    {
      XtAppProcessEvent(app_context,mask);
    }
}

void x11_connect(int connection)
{
  if (X11_device == NULL)
    X11_device = devCreateDev("X11 device",
			      DEV_OUTPUTHND, X11_defaultOutputHnd,
			      DEV_LISTENING, LISTENING | TALKING,
			      DEV_CLOSE_ON_ZERO, FALSE,
			      NULL);
  devConnectDev(X11_device,connection);
}
