/*****************************************************************************
 * PROJECT: TCA
 *
 * (c) Copyright Richard Goodwin, 1995. All rights reserved.
 *
 * FILE: timeUtils.h
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/utils/timeUtils.h,v $ 
 * $Revision: 1.4 $
 * $Date: 1996/08/05 16:15:15 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: timeUtils.h,v $
 * Revision 1.4  1996/08/05  16:15:15  rich
 * Added Brooke Wallace's changes to get devUtils to work with the access bus.
 *
 * Revision 1.3  1995/06/14  03:26:18  rich
 * Added DBMALLOC_DIR.
 * Fixed problems with multiple connections.
 *
 * Revision 1.2  1995/06/01  00:28:31  rich
 * Use TIME_MAX rather than LONG_MAX for timeouts.
 * Fix some problems with devUtils processOutput.
 *
 * Revision 1.1  1995/03/30  15:53:39  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Added ezx library and the devutils library.
 *
 *
 *****************************************************************************/

#ifndef TIMEUTIL_LOADED
#define TIMEUTIL_LOADED

#ifdef __cplusplus
extern "C" {
#endif

void subTime(struct timeval *t1, struct timeval *t2);
void addTime(struct timeval *t1,
	     struct timeval *t2,
	     struct timeval *result);
BOOLEAN lessTime(struct timeval *t1, struct timeval *t2);
BOOLEAN greaterTime (struct timeval *t1, struct timeval *t2);
void printTime(FILE *fd, struct timeval *t);

#define TIME_MAX 0x7FFFFFFF

#ifdef __cplusplus
}
#endif

#endif /* TIMEUTIL_LOADED */
