/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1995 Richard Goodwin.  All rights reserved.
 *
 * MODULE: 
 *
 * FILE: 
 *
 * ABSTRACT: Test for config package.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/utils/testConfig.c,v $ 
 * $Revision: 1.1 $
 * $Date: 1996/02/10 23:38:46 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: testConfig.c,v $
 * Revision 1.1  1996/02/10  23:38:46  rich
 * Added RWI's paramter parsing routines.
 *
 *
 *****************************************************************************/

#include "tca/libc.h"

#include "devConfig.h"


void main(int argc, char **argv)
{
  int intParam;
  float floatParam;
  double doubleParam;
  char stringParam[80];
  
  devConfigSetSearchPath(".:/tmp:..");
  devConfigLoadFile("testConfig.param");
  devParseParamArgs(argc, argv);

  /* Get original values. */
  devGetParamInt("intParam", &intParam);
  printf("intParam is %d\n",intParam);
  devGetParamFloat("floatParam", &floatParam);
  printf("floatParam is %f\n",floatParam);
  devGetParamDouble("doubleParam", &doubleParam);
  printf("doubleParam is %f\n",doubleParam);
  devGetParamString("stringParam", stringParam);
  printf("stringParam is %s\n",stringParam);
  
  /* Reset the values. */
  devSetParamInt("intParam", intParam+1);
  devGetParamInt("intParam", &intParam);
  printf("intParam is %d\n",intParam);
  floatParam += 1.0;
  devSetParamFloat("floatParam", floatParam);
  devGetParamFloat("floatParam", &floatParam);
  printf("floatParam is %f\n",floatParam);
  doubleParam += 1.0;
  devSetParamDouble("doubleParam", doubleParam);
  devGetParamDouble("doubleParam", &doubleParam);
  printf("doubleParam is %f\n",doubleParam);

  strcat(stringParam," Addition");
  devSetParamString("stringParam", stringParam);
  devGetParamString("stringParam", stringParam);
  printf("stringParam is \"%s\"\n",stringParam);
  exit(0);
}
