/*****************************************************************************
 * PROJECT: TCA
 *
 * (c) Copyright Richard Goodwin, 1995. All rights reserved.
 *
 * FILE: tcaDev.h
 *
 * ABSTRACT:
 * 
 * This file provides routines for connecting TCA to the set of device
 * interfaces (see devUtils.{c,h}).
 *
 * ADAPTED FROM XAVIER SOFTWARE TO FACILITATE ADDING I/O TO MODULES.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/utils/tcaDev.h,v $ 
 * $Revision: 1.12 $
 * $Date: 1996/08/05 16:15:14 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: tcaDev.h,v $
 * Revision 1.12  1996/08/05  16:15:14  rich
 * Added Brooke Wallace's changes to get devUtils to work with the access bus.
 *
 * Revision 1.11  1996/01/12  00:55:57  rich
 * Simplified GNUmakefiles. Fixed header include problem with release 8.3.
 *
 * Revision 1.10  1995/12/15  01:32:09  rich
 * Added routines to free data, devFreeDev and devFreeLineBuffer.
 * Added a parameter to set the behaviour when there is a signal, but no
 * characters to read on a socket.  Added routines to connect fds for
 * reading or sending only.  This is useful when spawning sub-processes and
 * you want to manage stdin, stdout and stderr.  This is used by nanny.
 * Added EZX_DestroyPopupPrompt and EZX_CenterPopup.
 *
 * Revision 1.9  1995/11/03  03:05:55  rich
 * Reid's fixes for handling multiple centrals.
 *
 * Revision 1.8  1995/10/29  18:30:15  rich
 * Fixes for context switching.  Propagated from 8.2 branch.
 *
 * Revision 1.7  1995/10/25  22:52:43  rich
 * The tca-device can now handle multiple central servers.
 * devUpdateConnections now takes the maximum number of connections.
 * The default stdin output handler now prints a prompt.
 *
 * Revision 1.6  1995/08/05  23:23:38  rich
 * Added functional interface to devUtils.  See the README for details.
 *
 * Revision 1.5  1995/07/19  14:32:58  rich
 * Error checking on select and accept calls.
 *
 * Revision 1.4  1995/07/06  21:23:36  rich
 * Solaris and Linux changes.
 *
 * Revision 1.3  1995/04/07  05:11:22  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Moved global variables into the c files and got rid of #define DECLARE_...
 * Now works with xavier stuff.
 *
 * Revision 1.2  1995/04/04  19:48:27  rich
 * Added sgi support.
 * Changed setAlarm to setTimer.
 * Numerous improvements and bug fixes in devUtils.
 *
 * Revision 1.1  1995/03/30  15:53:35  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Added ezx library and the devutils library.
 *
 *
 *****************************************************************************/

#ifndef TCA_DEV_LOADED
#define TCA_DEV_LOADED

#include "tca/libc.h"
#include "tca.h"

#ifndef DEVUTIL_LOADED
#include "tca/devUtils.h"
#endif


#ifdef __cplusplus
extern "C" {
#endif

typedef struct _TCA_DEV_TYPE *TCA_DEV_PTR;

extern TCA_DEV_PTR    TCA_device; /* the default or current tca device. */

/* Utility routines */

void TCA_outputHnd(int fd, long chars_available);

void TCA_setCentralHost(const char *machineName);

TCA_DEV_PTR TCA_connect(char *moduleName,void registerAll(void),
			void disconnectFn(void),void reconnectFn(void),
			const char **provides, const char **requires);

void TCA_disconnect(TCA_DEV_PTR tcaDev);

BOOLEAN TCA_isConnected(TCA_DEV_PTR tcaDev);

BOOLEAN TCA_isDisconnected(TCA_DEV_PTR tcaDev);

DEV_PTR TCA_getDev(TCA_DEV_PTR tcaDev);

void TCA_setContext(TCA_DEV_PTR tcaDev);


#ifdef __cplusplus
}
#endif

#endif /* TCA_DEV_LOADED */
