/*****************************************************************************
 * PROJECT: TCA
 *
 * (c) Copyright Richard Goodwin, 1995. All rights reserved.
 *
 * FILE: stdinDev.h
 *
 * ABSTRACT:
 * 
 * This file provides routines for connecting stdin to the set of device
 * interfaces (see devUtils.{c,h}).
 *
 * ADAPTED FROM XAVIER SOFTWARE TO FACILITATE ADDING I/O TO MODULES.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/utils/stdinDev.h,v $ 
 * $Revision: 1.6 $
 * $Date: 1996/08/05 16:15:13 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: stdinDev.h,v $
 * Revision 1.6  1996/08/05  16:15:13  rich
 * Added Brooke Wallace's changes to get devUtils to work with the access bus.
 *
 * Revision 1.5  1996/01/12  00:55:54  rich
 * Simplified GNUmakefiles. Fixed header include problem with release 8.3.
 *
 * Revision 1.4  1995/12/15  01:32:06  rich
 * Added routines to free data, devFreeDev and devFreeLineBuffer.
 * Added a parameter to set the behaviour when there is a signal, but no
 * characters to read on a socket.  Added routines to connect fds for
 * reading or sending only.  This is useful when spawning sub-processes and
 * you want to manage stdin, stdout and stderr.  This is used by nanny.
 * Added EZX_DestroyPopupPrompt and EZX_CenterPopup.
 *
 * Revision 1.3  1995/08/05  23:23:35  rich
 * Added functional interface to devUtils.  See the README for details.
 *
 * Revision 1.2  1995/04/04  19:48:23  rich
 * Added sgi support.
 * Changed setAlarm to setTimer.
 * Numerous improvements and bug fixes in devUtils.
 *
 * Revision 1.1  1995/03/30  15:53:33  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Added ezx library and the devutils library.
 *
 *
 *****************************************************************************/

#ifndef STDIN_DEV_LOADED
#define STDIN_DEV_LOADED

#ifndef DEVUTIL_LOADED
#include "tca/devUtils.h"
#endif

/* Global variables */

extern DEV_PTR  stdin_device;


#ifdef __cplusplus
extern "C" {
#endif

/* Utility routines */

int noinput (void);

void stdin_defaultInputHnd(int fd, long chars_available);

void stdin_connect(DEVICE_OUTPUT_HND stdinHnd);

#ifdef __cplusplus
}
#endif

#endif /* STDIN_DEV_LOADED */
