/*****************************************************************************
 * PROJECT: TCA
 *
 * (c) Copyright Richard Goodwin, 1995. All rights reserved.
 *
 * FILE: stdinDev.c
 *
 * ABSTRACT:
 * 
 * This file provides routines for connecting stdin to the set of device
 * interfaces (see devUtils.{c,h}).
 *
 * ADAPTED FROM XAVIER SOFTWARE TO FACILITATE ADDING I/O TO MODULES.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/utils/stdinDev.c,v $ 
 * $Revision: 1.10 $
 * $Date: 1996/01/12 00:55:52 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: stdinDev.c,v $
 * Revision 1.10  1996/01/12  00:55:52  rich
 * Simplified GNUmakefiles. Fixed header include problem with release 8.3.
 *
 * Revision 1.9  1995/10/25  22:52:40  rich
 * The tca-device can now handle multiple central servers.
 * devUpdateConnections now takes the maximum number of connections.
 * The default stdin output handler now prints a prompt.
 *
 * Revision 1.8  1995/10/07  19:11:42  rich
 * Pre-alpha release of tca-8.2.
 * Added PROJECT_DIR. Changed devIsConnected to devHasFd.
 *
 * Revision 1.7  1995/08/14  21:35:02  rich
 * Changed devReadN and devWriteN to take the same parameters as read and
 * write.  This allows macro substitution for the system calls.
 * Added "dev" prefix to everything.  Some minor fixes.
 *
 * Revision 1.6  1995/08/05  23:23:33  rich
 * Added functional interface to devUtils.  See the README for details.
 *
 * Revision 1.5  1995/06/14  03:26:11  rich
 * Added DBMALLOC_DIR.
 * Fixed problems with multiple connections.
 *
 * Revision 1.4  1995/06/01  00:28:27  rich
 * Use TIME_MAX rather than LONG_MAX for timeouts.
 * Fix some problems with devUtils processOutput.
 *
 * Revision 1.3  1995/04/07  05:11:19  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Moved global variables into the c files and got rid of #define DECLARE_...
 * Now works with xavier stuff.
 *
 * Revision 1.2  1995/04/04  19:48:22  rich
 * Added sgi support.
 * Changed setAlarm to setTimer.
 * Numerous improvements and bug fixes in devUtils.
 *
 * Revision 1.1  1995/03/30  15:53:31  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Added ezx library and the devutils library.
 *
 *
 *****************************************************************************/

#include "tca/libc.h"
#include "handlers.h"
#include "timeUtils.h"
#include "devUtils.h"
#include "stdinDev.h"

/*****************************************************************************
 * Global constants
 *****************************************************************************/

/*****************************************************************************
 * Global variables
 *****************************************************************************/

DEV_PTR    stdin_device = NULL;
/*
{
  NOT_CONNECTED,
  FALSE,
  { "", DEFAULT_PORT},
  { "Standard in", DEFAULT_BAUD},
  "Standard in",
  NO_FDS,
  NO_FDS,
  LISTENING | TALKING,
  FALSE,
  (FILE *) NULL,
  &devConnections,
  (DEVICE_OUTPUT_HND) stdin_defaultInputHnd,
  Null_Handler,  
  {TIME_MAX, 0},
  Null_Handler,  
  {0, 0},
  {TIME_MAX, 0},
  (void (*)(DEV_PTR)) NULL,  
  (void (*)(DEV_PTR)) NULL,  
  (void (*)(DEV_PTR)) NULL,  
};
*/


/*****************************************************************************
 *
 * FUNCTION: int noinput()
 *
 * DESCRIPTION:
 * A routine to check to see if there is any input available on stdin.
 * Returns TRUE if there is, FALSE otherwise.
 *
 * INPUTS:
 *
 * OUTPUTS: 
 *
 * HISTORY:
 *
 *****************************************************************************/

int noinput(void)
{
  long n=0;
  if( ioctl(fileno(stdin), FIONREAD, &n) == 0 ) {
    return( n==0 );
  }
  perror("ioctl");
  return FALSE;
}


/*****************************************************************************
 *
 * FUNCTION: void stdin_defaultInputHnd(int fd, int chars_available)
 *
 * DESCRIPTION: Handles character typed from stdin.
 *
 * INPUTS:
 *
 * OUTPUTS: 
 *
 * HISTORY:
 *
 *****************************************************************************/

void stdin_defaultInputHnd(int fd, long chars_available)
{
  static char buffer[DEFAULT_LINE_LENGTH+1];
  int numRead=0, i;
  
  bzero(buffer, DEFAULT_LINE_LENGTH+1);
  
  numRead = devReadN(fd, buffer, 
		     MIN(chars_available,DEFAULT_LINE_LENGTH));
  for (i=0; i<numRead; i++)
    if (buffer[i] == 'q')
      {
	printf("Quit command from console.\n");
	devShutdown();
	exit(0);
      }
  printf(">");
  fflush(stdout);
}

void stdin_connect(DEVICE_OUTPUT_HND stdinHnd)
{
  if (stdin_device == NULL)
    stdin_device = devCreateTTYDev("Standard in",
				   DEV_OUTPUTHND, stdin_defaultInputHnd,
				   NULL);
  devConnectDev(stdin_device,stdin_fd);
  if (stdinHnd != NULL)
    devSetOutputHnd(stdin_device, stdinHnd);

  printf(">");
  fflush(stdout);
}

