/*****************************************************************************
 * PROJECT: TCA
 *
 * (c) Copyright 1995 Richard Goodwin. All rights reserved.
 *
 * FILE: simDev.h
 *
 * ABSTRACT:
 * 
 * This file provides routines for connecting Sim to the set of device
 * interfaces (see devUtils.{c,h}).
 *
 * ADAPTED FROM XAVIER SOFTWARE TO FACILITATE ADDING I/O TO MODULES.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/utils/simDev.h,v $ 
 * $Revision: 1.6 $
 * $Date: 1996/08/05 16:15:12 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: simDev.h,v $
 * Revision 1.6  1996/08/05  16:15:12  rich
 * Added Brooke Wallace's changes to get devUtils to work with the access bus.
 *
 * Revision 1.5  1996/01/12  00:55:50  rich
 * Simplified GNUmakefiles. Fixed header include problem with release 8.3.
 *
 * Revision 1.4  1995/12/15  01:32:04  rich
 * Added routines to free data, devFreeDev and devFreeLineBuffer.
 * Added a parameter to set the behaviour when there is a signal, but no
 * characters to read on a socket.  Added routines to connect fds for
 * reading or sending only.  This is useful when spawning sub-processes and
 * you want to manage stdin, stdout and stderr.  This is used by nanny.
 * Added EZX_DestroyPopupPrompt and EZX_CenterPopup.
 *
 * Revision 1.3  1995/08/05  23:23:31  rich
 * Added functional interface to devUtils.  See the README for details.
 *
 * Revision 1.2  1995/07/30  03:50:11  rich
 * Fix for output parsing routine.  Compile utils with -g.
 *
 * Revision 1.1  1995/04/07  05:16:38  rich
 * Added x11Utils to connect tca to the X11 main loop.
 * Added sim device to use in creating simulators.
 *
 *
 *****************************************************************************/

#ifndef SIM_DEV_LOADED
#define SIM_DEV_LOADED

#ifndef DEVUTIL_LOADED
#include "tca/devUtils.h"
#endif

#define SIM_SERVER_PORT 1621
#define SIM_SERVER_NAME "robot simulator"

/* Max of 10 devices. */
#define MAX_SIM_DEVS 10

typedef void (*INIT_FN)(void);

/* structure for simulated devices */

typedef struct {
  DEV_PTR dev;
  INIT_FN initFN;
}  SIM_DEV_TYPE, *SIM_DEV_PTR;

/* structure for the server device. */

typedef struct {
  DEV_PTR dev;
  int numDevs;
  SIM_DEV_PTR devs[MAX_SIM_DEVS];
}  SIM_TYPE, *SIM_PTR;

#ifdef __cplusplus
extern "C" {
#endif

void Sim_outputHnd(int fd, long ignore);
BOOLEAN simServerInitialize(char *name);
void Sim_addDevice(SIM_DEV_PTR dev);
void Sim_closeDevices(void);

#ifdef __cplusplus
}
#endif

extern SIM_PTR    sim_device;

#endif /* SIM_DEV_LOADED */
